<?php

/**
* Theme Setup
*/
function merchandiser_theme_setup() {

	if ( ! isset($content_width) ) $content_width = 640; //pixels

	load_theme_textdomain( 'getbowtied', get_template_directory() . '/languages' );

	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );

	add_theme_support('html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	));

	// Blocks
	add_theme_support( 'align-wide' );
	add_theme_support( 'editor-styles' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'responsive-embeds' );

	add_editor_style( 'assets/css/backend/editor-styles.css' );

	// Remove Woocommerce Styles
	add_filter( 'woocommerce_enqueue_styles', '__return_false' );

	// Restore the classic widget editor.
    remove_theme_support( 'widgets-block-editor' );

	// WooCommerce
	add_theme_support( 'woocommerce', array(

	    // Product grid theme settings
	    'product_grid'        => array(
	        'default_rows'    => get_option('woocommerce_catalog_rows', 5),
	        'min_rows'        => 2,
	        'max_rows'        => '',

	        'default_columns' => get_option('woocommerce_catalog_columns', 5),
	        'min_columns'     => 1,
	        'max_columns'     => 6,
	    ),
	) );

	// WooCommerce Product Gallery
	add_theme_support( 'wc-product-gallery-slider' );
	if( Merchandiser_Options::getOption( 'product_image_zoom', true ) ) {
		add_theme_support( 'wc-product-gallery-zoom' );
	}

	// Menus
	register_nav_menus( array(
		'primary' 		=> esc_html__('Primary Menu', 'getbowtied'),
		'footer' 		=> esc_html__('Footer Menu', 'getbowtied'),
		'my-account'	=> esc_html__('My Account Menu', 'getbowtied')
	));

}
add_action( 'after_setup_theme', 'merchandiser_theme_setup' );

/**
* Theme ID
*/
function id_wacer98mu349ho8vsdkjalghwe98asle() { 
    if (is_front_page()) echo wp_kses_no_null('<div id="id-wacer98mu349ho8vsdkjalghwe98asle" style="display:none;">wacer98mu349ho8vsdkjalghwe98asle</div>');
}
add_action('wp_footer', 'id_wacer98mu349ho8vsdkjalghwe98asle');

/**
* Search - set post types to be retrieved
*/
function merchandiser_search_filter($query) {
    if ($query->is_search) {
        if ( !isset($query->query_vars['post_type']) ) {
            $query->set('post_type', array('post', 'page'));
        }
    }
    return $query;
}
add_filter( 'pre_get_posts','merchandiser_search_filter' );

/**
* Elementor - Register locations
*/
function merchandiser_register_elementor_locations( $elementor_theme_manager ) {
	$elementor_theme_manager->register_all_core_location();
}
add_action( 'elementor/theme/register_locations', 'merchandiser_register_elementor_locations' );
