<?php
/*
 * WPBakery Settings
 */
function merchandiser_wpbakery_config() {
 	//enable vc on post types
 	if(function_exists('vc_set_default_editor_post_types')) vc_set_default_editor_post_types( array('post','page','product','portfolio') );

 	if(function_exists('vc_set_as_theme')) {
 		vc_manager()->disableUpdater(true);
 		vc_set_as_theme(true);
 	}

 	// Remove vc_teaser
 	if (is_admin()) {
 		function remove_vc_teaser() {
 			remove_meta_box('vc_teaser', '' , 'side');
 		}
 		add_action( 'admin_head', 'remove_vc_teaser' );
 	}

    return;
}
add_action( 'init', 'merchandiser_wpbakery_config' );

/*
 * WPBakery Widget Area Class
 */
function merchandiser_wpbakery_widget_area_class( $class_string, $tag ) {
	if ( $tag == 'vc_widget_sidebar' ) {
		$class_string = str_replace( 'wpb_widgetised_column', 'wpb_widgetised_column widget-area', $class_string );
	}

	return $class_string;
}
add_filter( 'vc_shortcodes_css_class', 'merchandiser_wpbakery_widget_area_class', 10, 2 );

remove_action('vc_activation_hook', 'vc_page_welcome_set_redirect');
remove_action('admin_init', 'vc_page_welcome_redirect');
