<?php
/**
* The Header Elements section options.
*/

/**
 * Checks if wishlist icon is enabled.
 */
function merchandiser_wishlist_icon_enabled(){

    return Merchandiser_Options::getOption( 'header_wishlist', true );
}

/**
 * Checks if search icon is enabled.
 */
function merchandiser_search_icon_enabled(){

    return Merchandiser_Options::getOption( 'header_search', true );
}

/**
 * Checks if cart icon is enabled.
 */
function merchandiser_cart_icon_enabled(){

    return Merchandiser_Options::getOption( 'header_cart', true );
}

/**
 * Checks if account icon is enabled.
 */
function merchandiser_account_icon_enabled(){

    return Merchandiser_Options::getOption( 'header_user_account', true );
}

add_action( 'customize_register', 'merchandiser_customizer_header_elements_controls' );
/**
 * Adds controls for header elements section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_header_elements_controls( $wp_customize ) {

    // Wishlist.
    $wp_customize->add_setting(
		'header_wishlist',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'header_wishlist',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Wishlist', 'getbowtied' ),
                'description'   => esc_html__( 'Requires YITH WooCommerce Wishlist Plugin', 'getbowtied' ),
				'section'       => 'header_elements',
				'priority'       => 10,
			)
		)
	);

    // Wishlist Icon.
    $wp_customize->add_setting(
        'header_wishlist_icon',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_wishlist_icon',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'Wishlist Icon', 'getbowtied' ),
                'section'     => 'header_elements',
                'priority'    => 10,
                'active_callback' => 'merchandiser_wishlist_icon_enabled',
            )
        )
    );

    // Search.
    $wp_customize->add_setting(
		'header_search',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'header_search',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Search', 'getbowtied' ),
				'section'       => 'header_elements',
				'priority'       => 10,
			)
		)
	);

    // Search Icon.
    $wp_customize->add_setting(
        'header_search_icon',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_search_icon',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'Search Icon', 'getbowtied' ),
                'section'     => 'header_elements',
                'priority'    => 10,
                'active_callback' => 'merchandiser_search_icon_enabled',
            )
        )
    );

    // Cart.
    $wp_customize->add_setting(
		'header_cart',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'header_cart',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Cart', 'getbowtied' ),
				'section'       => 'header_elements',
				'priority'       => 10,
			)
		)
	);

    // Cart Icon.
    $wp_customize->add_setting(
        'header_cart_icon',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_cart_icon',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'Cart Icon', 'getbowtied' ),
                'section'     => 'header_elements',
                'priority'    => 10,
                'active_callback' => 'merchandiser_cart_icon_enabled',
            )
        )
    );

    // User Account.
    $wp_customize->add_setting(
		'header_user_account',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'header_user_account',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'User Account', 'getbowtied' ),
				'section'       => 'header_elements',
				'priority'       => 10,
			)
		)
	);

    // User Account Icon.
    $wp_customize->add_setting(
        'header_user_account_icon',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_user_account_icon',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'User Account Icon', 'getbowtied' ),
                'section'     => 'header_elements',
                'priority'    => 10,
                'active_callback' => 'merchandiser_account_icon_enabled',
            )
        )
    );

    $wp_customize->selective_refresh->add_partial( 'header_user_account', array(
        'selector' => '.site-header .header-wrapper .tools ul',
        'settings' => 'header_user_account',
        'render_callback' => function() {
            echo merchandiser_get_header_icons();
        },
    ) );
}

?>
