<?php
/**
* The Header Logo section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_header_logo_controls' );
/**
 * Adds controls for header logo section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_header_logo_controls( $wp_customize ) {

    // Logo.
    $wp_customize->add_setting(
        'header_logo',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_logo',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'Logo', 'getbowtied' ),
                'section'     => 'header_logo',
                'priority'    => 10,
            )
        )
    );

    $wp_customize->selective_refresh->add_partial( 'header_logo', array(
        'selector' => '.site-header .site-logo',
        'settings' => 'header_logo',
        'render_callback' => function() {
            merchandiser_get_header_logo('default');
        },
    ) );

    // Logo Height.
    $wp_customize->add_setting(
        'header_logo_height',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 75,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_logo_height',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Logo Max Height', 'getbowtied' ),
                'section'     => 'header_logo',
                'priority'    => 10,
                'description' => esc_html__( "(20px - 250px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 20,
                    'max'  => 250,
                    'step' => 1,
                ),
            )
        )
    );

    // Alternative Logo.
    $wp_customize->add_setting(
        'header_alt_logo',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_alt_logo',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'Alternative Logo', 'getbowtied' ),
                'description' => esc_html__( 'Used on mobile devices and transparent sticky header.', 'getbowtied' ),
                'section'     => 'header_logo',
                'priority'    => 10,
            )
        )
    );

    $wp_customize->selective_refresh->add_partial( 'header_alt_logo', array(
        'selector' => '.site-header .mobile-site-logo',
        'settings' => 'header_alt_logo',
        'render_callback' => function() {
            merchandiser_get_header_logo('alt');
        },
    ) );

    // Alternative Logo Height.
    $wp_customize->add_setting(
        'header_alt_logo_height',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 55,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_alt_logo_height',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Alternative Logo Max Height', 'getbowtied' ),
                'section'     => 'header_logo',
                'priority'    => 10,
                'description' => esc_html__( "(35px - 55px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 35,
                    'max'  => 55,
                    'step' => 1,
                ),
            )
        )
    );
}

?>
