<?php
/**
* The Styling section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_styling_controls' );
/**
 * Adds controls for styling section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_styling_controls( $wp_customize ) {

    // Base Font Color.
    $wp_customize->add_setting(
        'primary_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#000000',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'primary_color',
            array(
                'label'    => esc_html__( 'Base Font Color', 'getbowtied' ),
                'section'  => 'colors',
                'priority' => 10,
            )
        )
    );

    // Accent Color.
    $wp_customize->add_setting(
        'accent_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffc741',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'accent_color',
            array(
                'label'    => esc_html__( 'Accent Color', 'getbowtied' ),
                'section'  => 'colors',
                'priority' => 10,
            )
        )
    );

    // Global Page Background Color.
    $wp_customize->add_setting(
        'bg_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffffff',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'bg_color',
            array(
                'label'    => esc_html__( 'Global Page Background Color', 'getbowtied' ),
                'section'  => 'colors',
                'priority' => 10,
            )
        )
    );

    // Page Title Background Color.
    $wp_customize->add_setting(
        'page_title_bg_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffc741',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'page_title_bg_color',
            array(
                'label'    => esc_html__( 'Page Title Background Color', 'getbowtied' ),
                'section'  => 'colors',
                'priority' => 10,
            )
        )
    );

    // Page Title Text Color.
    $wp_customize->add_setting(
        'page_title_text_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffffff',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'page_title_text_color',
            array(
                'label'    => esc_html__( 'Page Title Text Color', 'getbowtied' ),
                'section'  => 'colors',
                'priority' => 10,
            )
        )
    );
}

?>
