<?php
/**
* The Footer section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_footer_controls' );
/**
 * Adds controls for footer section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_footer_controls( $wp_customize ) {

    // Sticky Footer.
    $wp_customize->add_setting(
        'footer_sticky',
        array(
            'type'                 => 'theme_mod',
            'capability'           => 'edit_theme_options',
            'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
            'default'              => false,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'footer_sticky',
            array(
                'type'          => 'checkbox',
                'label'         => esc_html__( 'Sticky Footer', 'getbowtied' ),
                'section'       => 'footer',
                'priority'      => 10,
            )
        )
    );

    // Back To Top Button.
    $wp_customize->add_setting(
        'back_to_top',
        array(
            'type'                 => 'theme_mod',
            'capability'           => 'edit_theme_options',
            'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
            'default'              => true,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'back_to_top',
            array(
                'type'          => 'checkbox',
                'label'         => esc_html__( 'Back To Top Button', 'getbowtied' ),
                'section'       => 'footer',
                'priority'      => 10,
            )
        )
    );

    // Footer Background Color.
    $wp_customize->add_setting(
        'footer_background_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#000000',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_background_color',
            array(
                'label'    => esc_html__( 'Footer Background Color', 'getbowtied' ),
                'section'  => 'footer',
                'priority' => 10,
            )
        )
    );

    // Footer Font Color.
    $wp_customize->add_setting(
        'footer_font_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffffff',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_font_color',
            array(
                'label'    => esc_html__( 'Footer Font Color', 'getbowtied' ),
                'section'  => 'footer',
                'priority' => 10,
            )
        )
    );

    // Footer Links Color.
    $wp_customize->add_setting(
        'footer_links_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffffff',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_links_color',
            array(
                'label'    => esc_html__( 'Footer Links Color', 'getbowtied' ),
                'section'  => 'footer',
                'priority' => 10,
            )
        )
    );

    // Footer Copyright.
    $wp_customize->add_setting(
		'footer_copyright',
		array(
			'type'               => 'theme_mod',
			'capability'         => 'edit_theme_options',
            'sanitize_callback'  => 'wp_kses',
			'default'            => esc_html__( 'Powered by ', 'getbowtied' ) . '<a href="'.MERCHANDISER_THEME_WEBSITE.'" title="eCommerce WordPress Theme for Woocommerce">'.esc_html__( 'Merchandiser', 'getbowtied' ).'</a>.',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'footer_copyright',
			array(
				'type'        => 'textarea',
				'label'       => esc_html__( 'Footer Copyright', 'getbowtied' ),
                'description' => esc_html__( 'Allowed HTML tags: a, abbr, acronym, b, blockquote, cite, code, del, em, i, q, s, strike, strong', 'getbowtied' ),
				'section'     => 'footer',
				'priority'    => 10,
			)
		)
	);

    // Merchandiser Credits.
    $wp_customize->add_setting(
		'merchandiser_credits',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'merchandiser_credits',
			array(
				'type'     => 'checkbox',
				'label'    => esc_html__( 'Theme Footer Credits', 'getbowtied' ),
				'section'  => 'footer',
				'priority' => 10,
			)
		)
	);
}

?>
