<?php


function getbowtied_theme_register_required_plugins() {

    $plugins = array(
        'woocommerce' => array(
            'name'               => 'WooCommerce',
            'slug'               => 'woocommerce',
            'required'           => true,
        ),
        'merchandiser-extender' => array(
            'name'               => 'Merchandiser Extender',
            'slug'               => 'merchandiser-extender',
            'source'             => 'https://getbowtied.github.io/repository/plugins/merchandiser-extender/merchandiser-extender.zip',
            'required'           => true,
            'external_url'       => 'https://1.envato.market/getbowtied-to-merchandiser'
        ),
        'kits-templates-and-patterns' => array(
            'name'               => 'Kits, Templates and Patterns',
            'slug'               => 'kits-templates-and-patterns',
            'required'           => false,
        ),
        'hookmeup'               => array(
            'name'               => 'HookMeUp – Unlock and use strategic spots in any WooCommerce Theme',
            'slug'               => 'hookmeup',
            'required'           => true,
        ),
        'yith-woocommerce-wishlist' => array(
            'name'               => 'WooCommerce Wishlist',
            'slug'               => 'yith-woocommerce-wishlist',
            'required'           => false,
        ),
        'js_composer' => array(
            'name'               => 'WPBakery - Legacy Page Builder',
            'slug'               => 'js_composer',
            'source'             => 'https://getbowtied.github.io/repository/plugins/wp-bakery/js_composer.zip',
            'required'           => false,
            'external_url'       => '',
            'version'            => '8.7.2'
        ),
    );

    $config = array(
        'id'               => 'getbowtied',
        'default_path'      => '',
        'parent_slug'       => 'getbowtied-dashboard',
        'menu'              => 'getbowtied-plugins',
        'capability'        => 'edit_theme_options',
        'has_notices'       => true,
        'is_automatic'      => true,
        //'message'             => '',
        'strings'      => array(
            'page_title'                      => __( 'Plugins', 'merchandiser' ),
            'menu_title'                      => __( 'Plugins', 'merchandiser' ),
        )
    );

    tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'getbowtied_theme_register_required_plugins' );
