<?php
/*
 * Offcanvas Left
 */

global $yith_wcwl;

$wishlist = ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && MERCHANDISER_WISHLIST_IS_ACTIVE && Merchandiser_Options::getOption( 'header_wishlist', true ) );
$account  = ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && Merchandiser_Options::getOption( 'header_user_account', true ) );
$logout   = ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && Merchandiser_Options::getOption( 'header_user_account', true ) && is_user_logged_in() );

?>


<div class="offcanvas_aside offcanvas_aside_left">
	<div class="offcanvas_aside_content">
		<div class="offcanvas_close">
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
				<path d="M 4.7070312 3.2929688 L 3.2929688 4.7070312 L 10.585938 12 L 3.2929688 19.292969 L 4.7070312 20.707031 L 12 13.414062 L 19.292969 20.707031 L 20.707031 19.292969 L 13.414062 12 L 20.707031 4.7070312 L 19.292969 3.2929688 L 12 10.585938 L 4.7070312 3.2929688 z"/>
			</svg>
		</div>

		<nav class="offcanvas_navigation">
			<?php

		    wp_nav_menu( array(
		        'theme_location'  => 'primary',
		        'fallback_cb'     => false,
		        'container'       => false,
				'menu_class' 	  => 'offcanvas_menu offcanvas_primary_menu',
		    ) );

			?>

			<?php if( $wishlist || $account || $logout ) { ?>

				<ul class="offcanvas_menu offcanvas_secondary_menu">

					<?php if( $wishlist ) { ?>
						<li class="menu-item wishlist-item">
			                <a class="tools_button" href="<?php echo esc_url($yith_wcwl->get_wishlist_url()); ?>">
			                    <?php esc_html_e('Wishlist', 'getbowtied'); ?>
			                </a>
			            </li>
					<?php } ?>

					<?php if( $account ) { ?>
						<li class="menu-item account-item">
							<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"><?php esc_html_e('My account', 'woocommerce'); ?></a>
						</li>
					<?php } ?>

					<?php if( $logout ) { ?>
						<li class="menu-item logout-item">
							<a href="<?php echo wp_logout_url( home_url() ); ?>"><?php esc_html_e('Logout', 'woocommerce'); ?></a>
						</li>
					<?php } ?>

				</ul>

			<?php } ?>
		</nav>

		<div class="offcanvas_sidebars">
			<?php
				// Is this a blog page?
				if (( (is_front_page() && is_home() ) || (is_home()) || (is_single()) || (is_archive()) || (is_sticky()) || (is_search())) && (MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && !is_woocommerce()) ):
					if ( is_active_sidebar( 'blog-widget-area' ) ) : ?>
						<div class="offcanvas_blog_sidebar">
					        <div class="widget-area">
					            <?php dynamic_sidebar( 'blog-widget-area' ); ?>
					        </div>
					    </div>
				    <?php
				    endif;
				endif;


				// Is this a woocommerce page?
				if (MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && is_woocommerce()):
					if ( is_active_sidebar( 'catalog-widget-area' ) ) : ?>
						<div class="offcanvas_shop_sidebar">
					        <div class="widget-area">
					            <?php dynamic_sidebar( 'catalog-widget-area' ); ?>
					        </div>
					    </div>
				    <?php endif;
				endif;
			?>
		</div>
	</div>
</div>
