<?php

get_header();

$featured_post_meta = get_post_meta( get_the_ID(), 'post_featured_image_meta_box_check', true );
$post_featured_image_option = !empty($featured_post_meta) ? $featured_post_meta : 'on';
?>

<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'single' ) ) { ?>

	<div id="primary" class="content-area">

		<?php if ( ('on' === $post_featured_image_option) && ( 'single_post_1' === Merchandiser_Options::getOption( 'single_post_layout', 'single_post_2' ) ) && has_post_thumbnail() ) { ?>
			<?php $post_thumbnail_id 	= get_post_thumbnail_id(); ?>
			<?php $image_url 			=  wp_get_attachment_url($post_thumbnail_id); ?>
			<div class="cover-image" style="background-image:url('<?php echo esc_url($image_url); ?>')"></div>
		<?php } ?>

		<div class="row">
			<div class="large-9 small-centered columns">

				<main id="main" class="site-main">
				<?php
					while ( have_posts() ) {
						the_post();
						get_template_part( 'content', 'single' );
					}
				?>
				</main>
			</div>

			<?php if( get_next_post() || get_previous_post() ) { ?>
				<nav class="navigation_between_posts" >
					<?php previous_post_link( '<div class="nav-previous">%link</div>', '' ); ?>
					<?php next_post_link( '<div class="nav-next">%link</div>', '' ); ?>
				</nav>
			<?php } ?>
		</div>

		<?php
		// If comments are open or we have at least one comment, load up the comment template
		if ( comments_open() || get_comments_number() ) {
			comments_template();
		}
		?>
	</div>

<?php } ?>

<?php get_footer(); ?>
