<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined( 'ABSPATH' ) || exit;

global $woocommerce_loop;

$parent_id    = get_queried_object_id();
$shop_page_id = get_option( 'woocommerce_shop_page_id' );

// Display Type.
$shop_display_type = ( isset( $_GET['s'] ) && ! empty( $_GET['s'] ) ) ? 'products' : woocommerce_get_loop_display_mode();

// Category Description.
$cat_desc = category_description();

// Header Image.
$listing_header_src = apply_filters( 'getbowtied_get_category_header_image', '' );
if ( is_shop() && has_post_thumbnail( $shop_page_id ) ) {
	$listing_header_src = wp_get_attachment_url( get_post_thumbnail_id( $shop_page_id ), 'full' );
}

// Page Title Option.
$show_page_title = 'on';
if ( is_shop() && get_post_meta( $shop_page_id, 'page_title_meta_box_check', true ) ) {
	$show_page_title = get_post_meta( $shop_page_id, 'page_title_meta_box_check', true );
}

$shop_header_class              = ( ! empty( $cat_desc ) || ! empty( $listing_header_src ) ) ? 'with-padding' : 'no-padding';
$shop_header_class             .= ! empty( $listing_header_src ) ? ' with-image' : '';
$listing_header_styles          = ( ! empty( $listing_header_src ) ) ? 'background-image:url(' . esc_url( $listing_header_src ) . ')' : '';
$shop_page_title_wrapper_class  = ( ! empty( $cat_desc ) || ! empty( $listing_header_src ) ) ? 'pulldown' : '';
$shop_page_title_wrapper_class .= ! empty( $listing_header_src ) ? ' transparent' : '';

// Shop Tools.
$show_shop_tools = ( ( ( is_shop() && ! empty( $listing_header_src ) ) || ( is_shop() && 'on' === $show_page_title && empty( $listing_header_src ) ) || ! is_shop() ) && ( 'subcategories' !== $shop_display_type ) );

// woocommerce_before_shop_loop.
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

add_action( 'woocommerce_before_shop_loop_result_count', 'woocommerce_result_count', 20 );
add_action( 'woocommerce_before_shop_loop_catalog_ordering', 'woocommerce_catalog_ordering', 30 );

// woocommerce_before_main_content.
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
remove_filter( 'woocommerce_product_loop_start', 'woocommerce_maybe_show_product_subcategories' );

get_header( 'shop' );

if ( apply_filters( 'woocommerce_show_page_title', true ) ) { ?>
	<header class="woocommerce-products-header shop-page-header <?php echo esc_attr( $shop_header_class ); ?>" style="<?php echo esc_attr( $listing_header_styles ); ?>">
		<div class="shop-page-category-description">
			<?php
			/**
			 * Hook: woocommerce_archive_description.
			 *
			 * @hooked woocommerce_taxonomy_archive_description - 10
			 * @hooked woocommerce_product_archive_description - 10
			 */
			do_action( 'woocommerce_archive_description' );
			?>
		</div>
		<div class="shop-page-title-bar <?php echo esc_attr( $shop_page_title_wrapper_class ); ?>">
			<div class="shop-page-title-wrapper">
				<?php if ( is_active_sidebar( 'catalog-widget-area' ) ) : ?>
					<div class="mobile-sidebar-toggle"></div>
				<?php endif; ?>

				<?php if ( ! is_shop() || 'on' === $show_page_title ) : ?>
					<h1 class="woocommerce-products-header__title shop-page-title entry-title page-title">
						<?php woocommerce_page_title(); ?>
					</h1>
				<?php endif; ?>
			</div>

			<?php
			if ( $show_shop_tools ) {
				/**
				* Hook: woocommerce_shop_loop_tools.
				*
				* @hooked merchandiser_shop_tools - 10
				*/
				do_action( 'woocommerce_shop_loop_tools' );
			}
			?>
		</div>
	</header>
<?php } ?>

<?php
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

if ( woocommerce_product_loop() && ( 'both' === $shop_display_type ) ) {
	?>
	<div class="shop_categories_wrapper">
		<div class="shop_categories_list_overlay"></div>

		<ul class="shop_categories_list">
			<?php
			woocommerce_output_product_categories(
				array(
					'parent_id'  => $parent_id,
					'hide_empty' => 0,
				)
			);
			?>
		</ul>
	</div>

	<?php
}

?>

<div class="row product-archive-wrapper">
	<div class="<?php echo ( Merchandiser_Options::getOption( 'shop_sidebar', true ) ) ? 'shop-listing-with-sidebar large-9 large-push-3' : 'shop-listing-no-sidebar large-12'; ?> columns">

		<?php
		/**
		 * Hook: woocommerce_before_shop_loop.
		 *
		 * @hooked woocommerce_output_all_notices - 10
		 */
		do_action( 'woocommerce_before_shop_loop' );

		if ( woocommerce_product_loop() ) {

			if ( 'subcategories' === $shop_display_type ) {
				?>

				<ul class="shop_categories_with_thumb">
					<?php
					woocommerce_output_product_categories(
						array(
							'parent_id'  => $parent_id,
							'hide_empty' => 0,
						)
					);
					?>
				</ul>

				<?php
			}

			if ( 'subcategories' !== $shop_display_type ) {

				woocommerce_product_loop_start();

				if ( wc_get_loop_prop( 'total' ) ) {
					while ( have_posts() ) {
						the_post();

						/**
						* Hook: woocommerce_shop_loop.
						*/
						do_action( 'woocommerce_shop_loop' );

						wc_get_template_part( 'content', 'product' );
					}
				}

				woocommerce_product_loop_end();
			}

			/**
			* Hook: woocommerce_after_shop_loop.
			*
			* @hooked woocommerce_pagination - 10
			*/
			do_action( 'woocommerce_after_shop_loop' );

		} else {
			?>
			<div class="no-products-info">
				<?php
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action( 'woocommerce_no_products_found' );
				?>
			</div>
			<?php
		}
		?>
	</div>

	<?php if ( Merchandiser_Options::getOption( 'shop_sidebar', true ) ) { ?>
		<div class="shop-sidebar large-3 large-pull-9 columns">
			<?php if ( is_active_sidebar( 'catalog-widget-area' ) ) { ?>
				<div id="secondary" class="widget-area" role="complementary">
					<?php dynamic_sidebar( 'catalog-widget-area' ); ?>
				</div>
			<?php } ?>
		</div>
	<?php } ?>

</div>

<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
