<?php
/**
 * The template for displaying product content within quickview offcanvas
 */

defined( 'ABSPATH' ) || exit;

while ( have_posts() ) {
	the_post();

	global $product;

	add_action( 'woocommerce_before_single_product_summary_product_images', 'woocommerce_show_product_sale_flash', 5 );
    add_action( 'woocommerce_before_single_product_summary_product_images', 'woocommerce_show_product_images', 10 );
    add_action( 'woocommerce_single_product_summary_single_title', 'woocommerce_template_single_title', 10 );
    add_action( 'woocommerce_single_product_summary_single_rating', 'woocommerce_template_single_rating', 10 );
    add_action( 'woocommerce_single_product_summary_single_price', 'woocommerce_template_single_price', 10 );
    add_action( 'woocommerce_single_product_summary_single_excerpt', 'woocommerce_template_single_excerpt', 10 );
	add_action( 'woocommerce_single_product_summary_single_excerpt', 'merchandiser_out_of_stock_badge', 15 );
    add_action( 'woocommerce_single_product_summary_single_add_to_cart', 'woocommerce_template_single_add_to_cart', 10 );
    add_action( 'woocommerce_single_product_summary_single_meta', 'woocommerce_template_single_meta', 10 );
	?>

	<div id="product-<?php the_ID(); ?>" <?php wc_product_class( 'product', $product ); ?>>
		<div class="product_content_wrapper">

			<div class="product-images-wrapper">
				<?php
				/**
				* Hook: woocommerce_before_single_product_summary_product_images.
				*
				* @hooked woocommerce_show_product_images - 10
				*/
				do_action( 'woocommerce_before_single_product_summary_product_images' );
				?>
				<div class="quickview-navigation">
					<div class="swiper-navigation-prev"></div>
					<div class="quickview-navigation-bullets"></div>
					<div class="swiper-navigation-next"></div>
				</div>
			</div>

			<div class="product_infos">

				<div class="product_title_price">

					<a href="<?php the_permalink(); ?>">
						<?php the_title( '<h2 class="offcanvas_product_title">', '</h2>' ); ?>
					</a>

					<div class="product_price">
						<?php
						/**
						* Hook: woocommerce_single_product_summary_single_price.
						*
						* @hooked merchandiser_product_badges - 5
						*/
						do_action( 'woocommerce_single_product_summary_single_price' );
						?>
					</div>
				</div>

				<div class="product_excerpt">
					<?php
					/**
					* Hook: woocommerce_single_product_summary_single_excerpt.
					*
					* @hooked woocommerce_template_single_excerpt - 10
					*/
					do_action( 'woocommerce_single_product_summary_single_excerpt' );
					?>
				</div>

				<?php
				/**
				* Hook: woocommerce_single_product_summary_single_add_to_cart.
				*
				* @hooked woocommerce_template_single_add_to_cart - 10
				*/
				do_action( 'woocommerce_single_product_summary_single_add_to_cart' );
				?>
			</div>
	    </div>
	</div>
<?php
}
