<?php
/**
 * SeaFood Company Framework: messages subsystem
 *
 * @package	seafood_company
 * @since	seafood_company 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Theme init
if (!function_exists('seafood_company_messages_theme_setup')) {
	add_action( 'seafood_company_action_before_init_theme', 'seafood_company_messages_theme_setup' );
	function seafood_company_messages_theme_setup() {
		// Core messages strings
		add_filter('seafood_company_filter_localize_script', 'seafood_company_messages_localize_script');
	}
}


/* Session messages
------------------------------------------------------------------------------------- */

if (!function_exists('seafood_company_get_error_msg')) {
	function seafood_company_get_error_msg() {
		return seafood_company_storage_get('error_msg');
	}
}

if (!function_exists('seafood_company_set_error_msg')) {
	function seafood_company_set_error_msg($msg) {
		$msg2 = seafood_company_get_error_msg();
		seafood_company_storage_set('error_msg', trim($msg2) . ($msg2=='' ? '' : '<br />') . trim($msg));
	}
}

if (!function_exists('seafood_company_get_success_msg')) {
	function seafood_company_get_success_msg() {
		return seafood_company_storage_get('success_msg');
	}
}

if (!function_exists('seafood_company_set_success_msg')) {
	function seafood_company_set_success_msg($msg) {
		$msg2 = seafood_company_get_success_msg();
		seafood_company_storage_set('success_msg', trim($msg2) . ($msg2=='' ? '' : '<br />') . trim($msg));
	}
}

if (!function_exists('seafood_company_get_notice_msg')) {
	function seafood_company_get_notice_msg() {
		return seafood_company_storage_get('notice_msg');
	}
}

if (!function_exists('seafood_company_set_notice_msg')) {
	function seafood_company_set_notice_msg($msg) {
		$msg2 = seafood_company_get_notice_msg();
		seafood_company_storage_set('notice_msg', trim($msg2) . ($msg2=='' ? '' : '<br />') . trim($msg));
	}
}


/* System messages (save when page reload)
------------------------------------------------------------------------------------- */
if (!function_exists('seafood_company_set_system_message')) {
	function seafood_company_set_system_message($msg, $status='info', $hdr='') {
		update_option(seafood_company_storage_get('options_prefix') . '_message', array('message' => $msg, 'status' => $status, 'header' => $hdr));
	}
}

if (!function_exists('seafood_company_get_system_message')) {
	function seafood_company_get_system_message($del=false) {
		$msg = get_option(seafood_company_storage_get('options_prefix') . '_message', false);
		if (!$msg)
			$msg = array('message' => '', 'status' => '', 'header' => '');
		else if ($del)
			seafood_company_del_system_message();
		return $msg;
	}
}

if (!function_exists('seafood_company_del_system_message')) {
	function seafood_company_del_system_message() {
		delete_option(seafood_company_storage_get('options_prefix') . '_message');
	}
}


/* Messages strings
------------------------------------------------------------------------------------- */

if (!function_exists('seafood_company_messages_localize_script')) {
	
	function seafood_company_messages_localize_script($vars) {
		$vars['strings'] = array(
			'ajax_error'		=> esc_html__('Invalid server answer', 'seafood-company'),
			'bookmark_add'		=> esc_html__('Add the bookmark', 'seafood-company'),
            'bookmark_added'	=> esc_html__('Current page has been successfully added to the bookmarks. You can see it in the right panel on the tab \'Bookmarks\'', 'seafood-company'),
            'bookmark_del'		=> esc_html__('Delete this bookmark', 'seafood-company'),
            'bookmark_title'	=> esc_html__('Enter bookmark title', 'seafood-company'),
            'bookmark_exists'	=> esc_html__('Current page already exists in the bookmarks list', 'seafood-company'),
			'search_error'		=> esc_html__('Error occurs in AJAX search! Please, type your query and press search icon for the traditional search way.', 'seafood-company'),
			'email_confirm'		=> esc_html__('On the e-mail address "%s" we sent a confirmation email. Please, open it and click on the link.', 'seafood-company'),
			'reviews_vote'		=> esc_html__('Thanks for your vote! New average rating is:', 'seafood-company'),
			'reviews_error'		=> esc_html__('Error saving your vote! Please, try again later.', 'seafood-company'),
			'error_like'		=> esc_html__('Error saving your like! Please, try again later.', 'seafood-company'),
			'error_global'		=> esc_html__('Global error text', 'seafood-company'),
			'name_empty'		=> esc_html__('The name can\'t be empty', 'seafood-company'),
			'name_long'			=> esc_html__('Too long name', 'seafood-company'),
			'email_empty'		=> esc_html__('Too short (or empty) email address', 'seafood-company'),
			'email_long'		=> esc_html__('Too long email address', 'seafood-company'),
			'email_not_valid'	=> esc_html__('Invalid email address', 'seafood-company'),
			'subject_empty'		=> esc_html__('The subject can\'t be empty', 'seafood-company'),
			'subject_long'		=> esc_html__('Too long subject', 'seafood-company'),
			'text_empty'		=> esc_html__('The message text can\'t be empty', 'seafood-company'),
			'text_long'			=> esc_html__('Too long message text', 'seafood-company'),
			'send_complete'		=> esc_html__("Send message complete!", 'seafood-company'),
			'send_error'		=> esc_html__('Transmit failed!', 'seafood-company'),
			'geocode_error'			=> esc_html__('Geocode was not successful for the following reason:', 'seafood-company'),
			'googlemap_not_avail'	=> esc_html__('Google map API not available!', 'seafood-company'),
			'editor_save_success'	=> esc_html__("Post content saved!", 'seafood-company'),
			'editor_save_error'		=> esc_html__("Error saving post data!", 'seafood-company'),
			'editor_delete_post'	=> esc_html__("You really want to delete the current post?", 'seafood-company'),
			'editor_delete_post_header'	=> esc_html__("Delete post", 'seafood-company'),
			'editor_delete_success'	=> esc_html__("Post deleted!", 'seafood-company'),
			'editor_delete_error'	=> esc_html__("Error deleting post!", 'seafood-company'),
			'editor_caption_cancel'	=> esc_html__('Cancel', 'seafood-company'),
			'editor_caption_close'	=> esc_html__('Close', 'seafood-company')
			);
		return $vars;
	}
}
?>