<?php
/* The GDPR Framework support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('seafood_company_gdpr_framework_theme_setup')) {
    add_action( 'seafood_company_action_before_init_theme', 'seafood_company_gdpr_framework_theme_setup', 1 );
    function seafood_company_gdpr_framework_theme_setup() {
        if (is_admin()) {
            add_filter( 'seafood_company_filter_required_plugins', 'seafood_company_gdpr_framework_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'seafood_company_exists_gdpr_framework' ) ) {
    function seafood_company_exists_gdpr_framework() {
		return defined( 'GDPR_FRAMEWORK_VERSION' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'seafood_company_gdpr_framework_required_plugins' ) ) {
    function seafood_company_gdpr_framework_required_plugins($list=array()) {
        if (in_array('gdpr-framework', (array)seafood_company_storage_get('required_plugins')))
            $list[] = array(
                'name'         => esc_html__('The GDPR Framework', 'seafood-company'),
                'slug'         => 'gdpr-framework',
                'required'     => false
            );
        return $list;
    }
}