<?php
/* Cookie Information support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('seafood_company_wp_gdpr_compliance_theme_setup')) {
    add_action( 'seafood_company_action_before_init_theme', 'seafood_company_wp_gdpr_compliance_theme_setup', 1 );
    function seafood_company_wp_gdpr_compliance_theme_setup() {
        if (is_admin()) {
            add_filter( 'seafood_company_filter_required_plugins', 'seafood_company_wp_gdpr_compliance_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'seafood_company_exists_wp_gdpr_compliance' ) ) {
    function seafood_company_exists_wp_gdpr_compliance() {
		return defined( 'WP_GDPR_C_ROOT_FILE' ) || defined( 'WPGDPRC_ROOT_FILE' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'seafood_company_wp_gdpr_compliance_required_plugins' ) ) {
    function seafood_company_wp_gdpr_compliance_required_plugins($list=array()) {
        if (in_array('wp-gdpr-compliance', (array)seafood_company_storage_get('required_plugins')))
            $list[] = array(
                'name'         => esc_html__('Cookie Information', 'seafood-company'),
                'slug'         => 'wp-gdpr-compliance',
                'required'     => false
            );
        return $list;
    }
}
