<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Accordion_El extends Widget_Base {

	public function get_name() {
		return 'thim-accordion';
	}

	public function get_title() {
		return esc_html__( 'Thim: Accordion', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-accordion';
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-accordion';
	}
	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Accordion', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

        $this->add_control(
            'show_first_panel',
            [
                'type'    => Controls_Manager::SWITCHER,
                'label'   => esc_html__( 'Show First Panel', 'coaching' ),
                'default' => false
            ]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'panel_title',
			[
				'label'       => esc_html__( 'Panel Title', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$repeater->add_control(
			'panel_body',
			[
				'label'       => esc_html__( 'Panel Body', 'coaching' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'panel',
			[
				'label'       => esc_html__( 'Panel List', 'coaching' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ panel_title }}}',
				'separator'   => 'before'
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_design_layout',
			array(
				'label'     => esc_html__( 'Header', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'list_event_header_title_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .widget-title' => 'color: {{VALUE}};',
 
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_title_header_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-widget-accordion .widget-title',
			]
		);
		$this->add_responsive_control(
			'list_event_item_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .thim-widget-accordion .widget-title' => 'text-align: {{VALUE}};', 
                ],
			]
		);
		$this->add_responsive_control(
			'accordion_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .widget-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
  				],
			]
		);
		$this->end_controls_section();
		$this->style_tabs_panel_titel();
		$this->style_tabs_panel_content();
	}
	protected function style_tabs_panel_titel(){
		$this->start_controls_section(
			'section_panel_title',
			[
				'label' => esc_html__( 'Panel Title', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-widget-accordion .panel-title a',
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title'      => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->start_controls_tabs(
			'accordion_group_tabs'
		);

		$this->start_controls_tab(
			'accordion_normal_tab',
			[
				'label' => esc_html__( 'NORMAL', 'coaching' ),
			]
		);
		$this->add_control(
			'title_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a' => 'background-color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a.collapsed' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'title_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a.collapsed' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'title_border_style',
			[
				'label'     => esc_html_x( 'Border Type', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'none'   => esc_html__( 'None', 'coaching' ),
					'solid'  => esc_html_x( 'Solid', 'Border Control', 'coaching' ),
					'double' => esc_html_x( 'Double', 'Border Control', 'coaching' ),
					'dotted' => esc_html_x( 'Dotted', 'Border Control', 'coaching' ),
					'dashed' => esc_html_x( 'Dashed', 'Border Control', 'coaching' ),
					'groove' => esc_html_x( 'Groove', 'Border Control', 'coaching' ),
				],
				'default'   => 'dashed',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a' => 'border-style: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'title_border_dimensions',
			[
				'label'     => esc_html_x( 'Width', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'condition' => [
					'title_border_style!' => 'none'
				],
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'title_border_color',
			[
				'label'     => esc_html_x( 'Border Color', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'condition' => [
					'title_border_style!' => 'none'
				],
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a.collapsed' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'accordion_hover_tab',
			[
				'label' => esc_html__( 'HOVER', 'coaching' ),
			]
		);
		$this->add_control(
			'title_color_active',
			[
				'label'     => esc_html__( 'Text Color Active', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a' => 'color: {{VALUE}};'
				],
			]
		);

		
		$this->add_control(
			'title_border_color_active',
			[
				'label'     => esc_html_x( 'Border Color Active', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'condition' => [
					'title_border_style!' => 'none'
				],
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'title_border_radius_active',
			[
				'label'      => esc_html__( 'Border Radius Active', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .panel-title a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_section();
	}
	protected function style_tabs_panel_content(){
		$this->start_controls_section(
			'section_panel_content',
			[
				'label' => esc_html__( 'Panel Content', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'content_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-widget-accordion .panel-collapse .panel-body',
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse .panel-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control( 
			'content_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse'      => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_control(
			'content_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse' => 'background-color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'content_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse .panel-body' => 'color: {{VALUE}};'
				],
			]
		);

		$this->add_responsive_control(
			'content_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_border_style',
			[
				'label'     => esc_html_x( 'Border Type', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'none'   => esc_html__( 'None', 'coaching' ),
					'solid'  => esc_html_x( 'Solid', 'Border Control', 'coaching' ),
					'double' => esc_html_x( 'Double', 'Border Control', 'coaching' ),
					'dotted' => esc_html_x( 'Dotted', 'Border Control', 'coaching' ),
					'dashed' => esc_html_x( 'Dashed', 'Border Control', 'coaching' ),
					'groove' => esc_html_x( 'Groove', 'Border Control', 'coaching' ),
				],
				'default'   => 'none',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse' => 'border-style: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control( 
			'content_border_dimensions',
			[
				'label'     => esc_html_x( 'Width', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'condition' => [
					'content_border_style!' => 'none'
				],
				'selectors' => [
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'content_border_color',
			[
				'label'     => esc_html_x( 'Border Color', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'condition' => [
					'content_border_style!' => 'none'
				],
				'selectors' => [ 
					'{{WRAPPER}} .thim-widget-accordion .panel-collapse' => 'border-color: {{VALUE}};',
				],
			]
		);

 		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		) );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Accordion_El() );
