<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Countdown_Box_El extends Widget_Base { 

	public function get_name() {
		return 'thim-countdown-box';
	}

	public function get_title() {
		return esc_html__( 'Thim: Countdown Box', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-countdown-box';
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-countdown-box';
	}
	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'config',
			[
				'label' => __( 'Countdown', 'coaching' )
			]
		);

		$this->add_control(
			'text_days',
			[
				'label'       => __( 'Text Days', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false
			]
		);

		$this->add_control(
			'text_hours',
			[
				'label'       => __( 'Text Hours', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false
			]
		);

		$this->add_control(
			'text_minutes',
			[
				'label'       => __( 'Text Minutes', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false
			]
		);

		$this->add_control(
			'text_seconds',
			[
				'label'       => __( 'Text Seconds', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false
			]
		);

        $this->add_control(
            'time_year',
            [
                'label'       => __( 'Year', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false
            ]
        );

        $this->add_control(
            'time_month',
            [
                'label'       => __( 'Month', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false
            ]
        );

        $this->add_control(
            'time_day',
            [
                'label'       => __( 'Day', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false
            ]
        );

        $this->add_control(
            'time_hour',
            [
                'label'       => __( 'Hour', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false
            ]
        );

        $this->add_control(
            'style_color',
            [
                'label'   => esc_html__( 'Style Color', 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'white' => esc_html__( 'White', 'coaching' ),
                    'black'  => esc_html__( 'Black', 'coaching' )
                ],
                'default' => 'base'
            ]
        );


		$this->add_control(
			'text_align',
			[
				'label'   => __( 'Text Alignment', 'coaching' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'text-left'   => [
						'title' => __( 'Left', 'coaching' ),
						'icon'  => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'coaching' ),
						'icon'  => 'fa fa-align-center',
					],
					'text-right'  => [
						'title' => __( 'Right', 'coaching' ),
						'icon'  => 'fa fa-align-right',
					]
				],
				'default' => 'text-left',
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_style',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				
			]
		);
 	 
		$this->add_control(
			'color',
			[
				'label'     => esc_html__( 'Text Number Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .counter-block .counter' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'color_caption',
			[
				'label'     => esc_html__( 'Text caption Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .counter-block .counter-caption' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'countdown_border',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .counter-group .counter-block',	
			]
		);
		 

		$this->add_control(
			'countdown_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .counter-block'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
 				),
			)
		);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		thim_get_widget_template( $this->get_base(), array( 'instance' => $settings ) );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Countdown_Box_El() );
