<?php
namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Counters_Box_El extends Widget_Base {

	public function get_name() {
		return 'thim-counters-box';
	}

	public function get_title() {
		return esc_html__( 'Thim: Counters Box', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-counters-box';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Counters Box', 'coaching' )
			]
		);

		$this->add_control(
			'counters_label',
			[
				'label'       => esc_html__( 'Counters Label', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'counters_value',
			[
				'label'   => esc_html__( 'Counters Value', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 20,
				'min'     => 1,
				'step'    => 1
			]
		);

		$this->add_control(
			'icon',
			[
				'label'       => esc_html__( 'Select Icon:', 'coaching' ),
				'type'        => Controls_Manager::ICON,
				'placeholder' => esc_html__( 'Choose...', 'coaching' )
			]
		);

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Counter Style', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					"home-page"     => esc_html__( "Home Page", 'coaching' ),
					"about-us"      => esc_html__( "Page About Us", 'coaching' ),
					"home-effective"   => esc_html__( "Home Effective", 'coaching' ),
					"home-5"         => esc_html__( "Home 5 Style", 'coaching' ),
				],
				'default' => 'home-page'
			]
		);

        $this->add_control(
            'css_animation',
            [
                'label'   => esc_html__( 'CSS Animation', 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ""              => esc_html__( "No", 'coaching' ),
                    "top-to-bottom" => esc_html__( "Top to bottom", 'coaching' ),
                    "bottom-to-top" => esc_html__( "Bottom to top", 'coaching' ),
                    "left-to-right" => esc_html__( "Left to right", 'coaching' ),
                    "right-to-left" => esc_html__( "Right to left", 'coaching' ),
                    "appear"        => esc_html__( "Appear from center", 'coaching' )
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'style-tab',
			[
				'label' => esc_html__( 'Style', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'counter_number_h',
			[
				'label' => esc_html__( 'Number', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
            'counter_number_color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .home-5 .display-percentage' => 'background-image: linear-gradient(to left,var(--thim-body-primary-color,#2e8ece),{{VALUE}}),linear-gradient(to bottom,#ffffff,#ffffff);',
					'{{WRAPPER}} .display-percentage' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'counter_number_typography',
				'selector' => '{{WRAPPER}} .display-percentage',
			]
		);
		$this->add_control(
			'list_post_label_h',
			[
				'label' => esc_html__( 'Label', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
            'counter_label_color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-box-content' => 'color: {{VALUE}};',
					'{{WRAPPER}} .display-percentage:before'=> 'background-color: {{VALUE}};'
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'counter_label_typography',
				'selector' => '{{WRAPPER}} .counter-box-content',
			]
		);
		$this->add_control(
			'list_post_icon_h',
			[
				'label' => esc_html__( 'Icon', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border Color Icon', 'coaching' ),
				'type'  => Controls_Manager::COLOR,
			]
		);
		$this->add_control(
			'counter_color',
			[
				'label' => esc_html__( 'Counters Icon Color', 'coaching' ),
				'type'  => Controls_Manager::COLOR,
			]
		);

		$this->end_controls_section(); 
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		
 		$settings['icon'] = str_replace("fa fa-", "", $settings['icon']);
		$args                 = array();
		$args['before_title'] = '<h3 class="widget-title">';
		$args['after_title']  = '</h3>';

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings,
			'args'     => $args
		) );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Counters_Box_El() );
