<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Course_Categories_El extends Widget_Base {

	public function get_name() {
		return 'thim-course-categories';
	}

	public function get_title() {
		return esc_html__( 'Thim: Course Categories', 'coaching' );
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-course-categories';
	}
	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-course-categories';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => __( 'Course Categories', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'slider'     => esc_html__( 'Slider', 'coaching' ),
					'list'       => esc_html__( 'List Categories', 'coaching' ),
				],
				'default' => 'list'
			]
		);

		$this->end_controls_section();


        $this->start_controls_section(
            'slider-options',
            [
                'label'     => esc_html__( 'Slider Options', 'coaching' ),
                'condition' => array(
                    'layout' => [ 'slider' ]
                )
            ]
        );

        $this->add_control(
            'limit',
            [
                'label'   => esc_html__( 'Limit Number Courses', 'coaching' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 15,
                'min'     => 1,
                'step'    => 1
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'        => esc_html__( 'Show Pagination?', 'coaching' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'coaching' ),
                'label_off'    => esc_html__( 'No', 'coaching' ),
                'return_value' => 'yes',
                'default'      => ''
            ]
        );

        $this->add_control(
            'show_navigation',
            [
                'label'        => esc_html__( 'Show Navigation?', 'coaching' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'coaching' ),
                'label_off'    => esc_html__( 'No', 'coaching' ),
                'return_value' => 'yes',
                'default'      => 'yes'
            ]
        );

        $this->add_control(
            'item_visible',
            [
                'label'   => esc_html__( 'Limit Number Courses', 'coaching' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 7,
                'min'     => 1,
                'max'     => 8,
                'step'    => 1
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'list-options',
            [
                'label'     => esc_html__( 'List Options', 'coaching' ),
                'condition' => array(
                    'layout' => [ 'list' ]
                )
            ]
        );



        $this->add_control(
            'show_counts',
            [
                'label'   => esc_html__( 'Show course counts', 'coaching' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'coaching' ),
                'label_off'    => esc_html__( 'No', 'coaching' ),
                'return_value' => 'yes',
                'default'      => ''
            ]
        );

        $this->add_control(
            'hierarchical',
            [
                'label'   => esc_html__( 'Show hierarchy', 'coaching' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'coaching' ),
                'label_off'    => esc_html__( 'No', 'coaching' ),
                'return_value' => 'yes',
                'default'      => 'yes'
            ]
        );

        $this->end_controls_section();
        $this->course_cats_tabs_style();
	}
    protected  function course_cats_tabs_style(){
        $this->start_controls_section(
			'course_cats_section',
			array(
				'label'     => esc_html__( 'Title', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
        $this->add_control(
			'course_cats_title_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-cats-header .widget-title' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'course_cats_title_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .course-cats-header .widget-title',
			]
		);
		$this->add_responsive_control(
			'content_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .course-cats-header .widget-title' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
			'course_cats_list_section',
			array(
				'label'     => esc_html__( 'List items', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
        $this->add_control(
			'course_cats_title_section',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        // start tab for item
		$this->start_controls_tabs(
            'courses_cats_item_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'courses_cats_style_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
        $this->add_control(
			'course_cats_list_title_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .cat-item a' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .thim-carousel-course-categories .title a' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'course_cats_list_title1_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .cat-item a,{{WRAPPER}} .cat-item,{{WRAPPER}} .thim-carousel-course-categories .title a',
			]
		);
        $this->add_control(
			'padding',
			[
				'label' => esc_html__( 'Padding', 'coaching' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .cat-item,{{WRAPPER}} .thim-carousel-course-categories .title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'courses_cats_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
        $this->add_control(
			'course_cats_list_title_color_hover',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .cat-item a:hover,{{WRAPPER}}  .cat-item:hover' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .thim-carousel-course-categories .title a:hover' => 'color: {{VALUE}}!important;',
				],
			]
		);
        $this->end_controls_tab();
		// end hover tab

		$this->end_controls_tabs();
        $this->add_control(
			'course_cats_item_number_section',
			[
				'label' => esc_html__( 'Number', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => array(
					'layout' => ['list'],
				),
			]
		);
        $this->add_control(
			'course_cats_list_number_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}}  .cat-item' => 'color: {{VALUE}};',
				],
                'condition' => array(
					'layout' => ['list'],
				),
			]
		);
        $this->end_controls_section();
    }
	protected function render() {
		$settings = $this->get_settings_for_display();

		// Map variables between Elementor and SiteOrigin
		$instance = array(
			'title'          => $settings['title'],
			'layout'         => $settings['layout'],
            'slider-options'    => array(
                'limit' => $settings['limit'],
                'show_navigation' => $settings['show_navigation'],
                'item_visible'    => $settings['item_visible'],
                'show_pagination'       => $settings['show_pagination']
            ),
			'list-options'   => array(
				'show_counts'  => $settings['show_counts'],
				'hierarchical' => $settings['hierarchical']
			)
		);

		$args                 = array();
		$args['before_title'] = '<div class="course-cats-header"><h3 class="widget-title">';
		$args['after_title']  = '</h3></div>';

        if( $instance['layout'] && 'slider' == $instance['layout'] ){
            $layout = 'slider';
        }else{
            $layout = 'base';
        }
//        if ( thim_is_new_learnpress( '2.0' ) ) {
//            $layout .= '-v2';
//        }

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $instance,
			'args'     => $args
		), $layout );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Course_Categories_El() );
