<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Courses_El extends Widget_Base {

	public function get_name() {
		return 'thim-courses';
	}

	public function get_title() {
		return esc_html__( 'Thim: Courses', 'coaching' );
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-courses';
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-courses';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Courses', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Heading', 'coaching' ), 
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' )
			]
		);

		$this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'slider'         => esc_html__( 'Slider', 'coaching' ),
					'grid'           => esc_html__( 'Grid', 'coaching' ),
					'list-sidebar'   => esc_html__( 'List Sidebar', 'coaching' ),
					'megamenu'       => esc_html__( 'Mega Menu', 'coaching' ),
					'grid-bussiness' => esc_html__( 'Grid Bussiness', 'coaching' ),
					'grid-effective' => esc_html__( 'Grid Effective', 'coaching' ),
					'grid-gym'       => esc_html__( 'Grid Gym', 'coaching' ),
					'grid-therapist' => esc_html__( 'Grid Therapist', 'coaching' ),
					'grid-home5'     => esc_html__( 'Grid Home 5', 'coaching' ),
				],
				'default' => 'slider'
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order By', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'popular'  => esc_html__( 'Popular', 'coaching' ),
					'latest'   => esc_html__( 'Latest', 'coaching' ),
					'category' => esc_html__( 'Category', 'coaching' )
				],
				'default' => 'latest'
			]
		);

		$this->add_control(
			'cat_id',
			[
				'label'     => esc_html__( 'Select Category', 'coaching' ),
				'type'      => Controls_Manager::SELECT2,
				'options'   => thim_get_cat_taxonomy( 'course_category', array( 'all' => esc_html__( 'All', 'coaching' ) ) ),
				'condition' => array(
					'order' => [ 'category' ]
				)
			]
		);

		$this->add_control(
			'thumbnail_width',
			[
				'label'      => __( 'Thumbnail Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 100,
						'max'  => 800,
						'step' => 1, 
					]
				],
				'default'    => [
					'unit' => 'px',
					'size' => 400,
				],
				'condition'  => array(
					'layout' => [
						'slider',
						'grid',
						'grid-bussiness',
						'grid-effective',
						'grid-gym',
						'grid-therapist',
						'grid-home5'
					]
				)
			]
		);

		$this->add_control(
			'thumbnail_height',
			[
				'label'      => __( 'Thumbnail Height', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 100,
						'max'  => 800,
						'step' => 1,
					]
				],
				'default'    => [
					'unit' => 'px',
					'size' => 300,
				],
				'condition'  => array(
					'layout' => [
						'slider',
						'grid',
						'grid-bussiness',
						'grid-effective',
						'grid-gym',
						'grid-therapist',
						'grid-home5'
					]
				)
			]
		);

		$this->add_control(
			'limit',
			[
				'label'   => esc_html__( 'Limit Number Courses', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 8,
				'min'     => 1,
				'step'    => 1
			]
		);
		$this->add_control(
			'view_all_courses',
			[
				'label'     => esc_html__( 'View All Text', 'coaching' ),
				'type'      => Controls_Manager::TEXT,
				'condition' => array(
					'layout' => [ 'slider', 'grid', 'grid-bussiness', 'grid-effective', 'grid-home5' ]
				)
			]
		);

		$this->add_control(
			'view_all_position',
			[
				'label'       => __( 'View All Position', 'coaching' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => [
					'top'    => [
						'title' => __( 'Top', 'coaching' ),
						'icon'  => 'eicon-v-align-top',
					],
					'bottom' => [
						'title' => __( 'Bottom', 'coaching' ),
						'icon'  => 'eicon-v-align-bottom',
					],
				],
				'default'     => 'top',
				'toggle'      => false,
				'label_block' => false,
				'condition'   => array(
					'layout' => [ 'slider', 'grid', 'grid-bussiness', 'grid-effective', 'grid-home5' ]
				)
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider-options',
			[
				'label'     => esc_html__( 'Slider Options', 'coaching' ),
				'condition' => array(
					'layout' => [ 'slider' ]
				)
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label'        => esc_html__( 'Show Pagination?', 'coaching' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'coaching' ),
				'label_off'    => esc_html__( 'No', 'coaching' ),
				'return_value' => 'yes',
				'default'      => ''
			]
		);

		$this->add_control(
			'show_navigation',
			[
				'label'        => esc_html__( 'Show Navigation?', 'coaching' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'coaching' ),
				'label_off'    => esc_html__( 'No', 'coaching' ),
				'return_value' => 'yes',
				'default'      => 'yes'
			]
		);

		$this->add_control(
			'item_visible',
			[
				'label'   => esc_html__( 'Limit Number Courses', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 6,
				'step'    => 1
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'grid-options',
			[
				'label'     => esc_html__( 'Grid Options', 'coaching' ),
				'condition' => array(
					'layout' => [
						'grid',
						'grid-bussiness',
						'grid-effective',
						'grid-gym',
						'grid-therapist',
						'grid-home5'
					]
				)
			]
		);

		$this->add_control(
			'columns',
			[
				'label'   => esc_html__( 'Columns', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 6,
				'step'    => 1
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'title_widget_settings',
			[
				'label' => esc_html__( 'Heading', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE, 
			]
		);
		$this->add_control(
			'title_widget_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-widget-courses .widget-title' => 'color: {{VALUE}};',
 
				], 
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_widget_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-widget-courses .widget-title',
			]
		);
		$this->add_responsive_control(
			'course_widget_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .thim-widget-courses' => 'text-align: {{VALUE}};', 
                ],
			]
		);
		$this->add_responsive_control( 
			'course_widget_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-courses .widget-title' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_section(); 
		$this->courses_tabs_style_sc();
		$this->courses_nav_style();
	}
	protected function courses_tabs_style_sc(){
		$this->start_controls_section(
			'item_settings',
			[
				'label' => esc_html__( 'Item', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		// start tab for item
		$this->start_controls_tabs(
            'style_item_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'item_style_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
		$this->add_control(
			'item_background',
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-content' => 'background-color: {{VALUE}};' 

				],
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_responsive_control( 
			'course_item_space_bottom',
			[
				'label'      => esc_html__( 'Space Bottom', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .lpr_course ' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;'
				],
				'condition' => array(
					'layout' => ['list-sidebar','megamenu'],
				),
			]
		);
		$this->add_responsive_control(
			'course_items_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-course-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					
  				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-item .thim-course-content,{{WRAPPER}} .thim-course-grid.bussiness  .course-thumbnail',
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness','grid-effective','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_responsive_control(
			'item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .course-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0px  0px;',
					'{{WRAPPER}} .thim-course-content' => 'border-radius: 0px 0px {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .thim-course-grid.bussiness  .course-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .thim-course-grid.bussiness .course-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .course-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'	
				],
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness','grid-effective','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_control(
			'title_line_color',
			[
				'label'     => esc_html__( 'Line Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid  .course-meta:after' => 'background: {{VALUE}} !important;',
					'{{WRAPPER}}  .thim-course-grid.effective-layout  .course-meta:before' => 'background-color: {{VALUE}} !important;', 
				],
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness','grid-effective','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-item',
				'condition' => array(
					'layout' =>['slider','grid','grid-bussiness','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);

		$this->add_control(
			'couses_title_hedding',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				// 'condition' => array(
				// 	'layout' => ['grid-gym'],
				// ),
			]
		);
		$this->add_control(
			'title_couses_color',
			[
				'label'     => esc_html__( 'Title Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-title a,{{WRAPPER}} .thim-course-grid.bussiness .course-title a,
					{{WRAPPER}}  .thim-course-grid.home5-layout .course-title a' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_fgfdg_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-title a,{{WRAPPER}}  .thim-course-grid.home5-layout .course-title a,
				{{WRAPPER}}  .thim-course-grid.bussiness .course-title a',
			]
		);
		$this->add_responsive_control(
			'item_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .course-title,{{WRAPPER}}  .thim-course-grid.home5-layout .course-title a' => 'text-align: {{VALUE}};',
                ],
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_responsive_control( 
			'course_title_space_top',
			[
				'label'      => esc_html__( 'Space Top', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .course-title,{{WRAPPER}}  .thim-course-grid.home5-layout .course-title a' => 'padding-top: {{SIZE}}{{UNIT}}!important;'
				],
				// 'condition' => array(
				// 	'layout' => ['slider','grid','grid-effective','grid-gym','grid-therapist','grid-home5'],
				// ),
			]
		);
		$this->add_responsive_control( 
			'course_title_space_bottom',
			[
				'label'      => esc_html__( 'Space Bottom', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .course-title,{{WRAPPER}}  .thim-course-grid.home5-layout .course-title a' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;'
				],
				// 'condition' => array(
				// 	'layout' => ['slider','grid','grid-effective','grid-gym','grid-therapist','grid-home5'],
				// ),
			]
		);
		$this->add_control(
			'couses_des_hedding',
			[
				'label' => esc_html__( 'Description', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['grid-gym'],
				),
			]
		);
		$this->add_control(
			'des_couses_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-content .description' => 'color: {{VALUE}};',
				],
				'condition' => array(
					'layout' => ['grid-gym'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'course_des_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-course-content .description',
				'condition' => array(
					'layout' => ['grid-gym'],
				),
			]
		);
		
		$this->add_responsive_control( 
			'course_des_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .description' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'layout' => ['grid-gym'],
				),
			]
		);

		$this->add_control(
			'couses_author_hedding',
			[
				'label' => esc_html__( 'Author', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness'],
				),
			]
		);
		$this->add_control(
			'author_couses_color',
			[
				'label'     => esc_html__( 'Author Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-author .value a,{{WRAPPER}} .thim-course-grid.bussiness .author-contain a' => 'color: {{VALUE}};',
				],
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'author_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-author .value a span',
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness'],
				),
			]
		);
		
		$this->add_control(
			'couses_Students_hedding',
			[
				'label' => esc_html__( 'Students', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['slider','grid','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_control(
			'students_couses_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-students .value,{{WRAPPER}}  .thim-course-grid.gym-layout  .course-students .value
					,{{WRAPPER}} .course-meta .students-feature span,{{WRAPPER}} .students-feature i' => 'color: {{VALUE}} !important;',
				],
				'condition' => array(
					'layout' => ['slider','grid','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_control(
			'students_couses_numbercolor',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid.gym-layout .course-info span' => 'color: {{VALUE}} !important;',
				],
				'condition' => array(
					'layout' => ['grid-gym'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'students_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-course-grid .course-meta .value,{{WRAPPER}} .thim-course-grid .course-item .thim-course-content .middle .course-students .value,{{WRAPPER}} .thim-course-grid.home5-layout .lpr_course .course-meta .students-feature span,
				{{WRAPPER}} .thim-course-grid .course-item .thim-course-content .middle .course-students .value i,{{WRAPPER}} .thim-course-grid.home5-layout .lpr_course .course-meta .students-feature i,
				{{WRAPPER}} .thim-course-grid.gym-layout .course-info span,{{WRAPPER}} .thim-course-grid.therapist-layout .course-meta .students-feature span,{{WRAPPER}} .thim-course-grid.therapist-layout .course-meta .students-feature i',
				'condition' => array(
					'layout' => ['slider','grid','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);
		$this->add_control(
			'couses_duration_hedding',
			[
				'label' => esc_html__( 'Duration', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
		$this->add_control(
			'duration_couses_color',
			[
				'label'     => esc_html__( ' Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .duration-feature .label,{{WRAPPER}} .duration-feature i' => 'color: {{VALUE}} !important;',
				],
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'duration_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .duration-feature .label',
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
		$this->add_control(
			'duration_time_couses_color',
			[
				'label'     => esc_html__( 'Time Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .duration-feature .value' => 'color: {{VALUE}} !important;',
				],
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
		$this->add_control(
			'couses_review_hedding',
			[
				'label' => esc_html__( 'Review', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['list-sidebar','grid-effective','grid-home5'],
				),
			]
		);
		$this->add_control(
			'review_couses_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-review label,{{WRAPPER}} .number-comment .value,
					{{WRAPPER}} .course-review .value  span' => 'color: {{VALUE}};',
				],
				'condition' => array(
					'layout' => ['list-sidebar','grid-effective','grid-home5'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'review_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-review label,{{WRAPPER}} .number-comment .value,{{WRAPPER}} .course-review .value  span',
				'condition' => array(
					'layout' => ['list-sidebar','grid-effective','grid-home5'],
				),
			]
		);
		$this->add_control(
			'couses_price_hedding',
			[
				'label' => esc_html__( 'Price', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'price_free_text_couses_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid.gym-layout .course-price>span' => 'color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['grid-gym'],
				),
			]
		);
		$this->add_control(
			'price_free_couses_color',
			[
				'label'     => esc_html__( 'Price Free Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid .value.free-course,
					{{WRAPPER}}  .thim-course-grid.bussiness .value.free-course' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-course-grid.home5-layout .lpr_course  .course-price .value ' => 'background-image: linear-gradient(to left,{{VALUE}},{{VALUE}}),linear-gradient(to bottom,#fff,#fff);',
					
				],
			]
		);
		
		$this->add_control(
			'price_couses_color',
			[
				'label'     => esc_html__( 'Price Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-content .course-meta>div.course-price .value,
					{{WRAPPER}} .thim-course-grid.bussiness .course-price .value,
					{{WRAPPER}} .thim-course-grid.gym-layout .course-price>span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'price_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-course-grid .lpr_course .value.free-course,{{WRAPPER}} .course-price span,{{WRAPPER}} .thim-course-grid.bussiness .course-price .value,
				{{WRAPPER}} .thim-course-grid .course-item .thim-course-content .course-meta>div.course-price .value,{{WRAPPER}} .thim-course-list-sidebar .free-course,{{WRAPPER}}  .thim-course-megamenu .course-price .value',
			]
		);
		$this->add_responsive_control(
			'price_couses_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-course-grid.bussiness .course-price .value' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
  				],
				  'condition' => array(
					'layout' => ['grid-bussiness'],
				),
			]
		);
		$this->add_control(
			'BG_price_couses_color',
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid.bussiness .course-price .value' => 'background-color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['grid-bussiness'],
				),
			]
		);
		$this->add_control(
			'couses_term_hedding',
			[
				'label' => esc_html__( 'Term', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['grid-effective','grid-gym'],
				),
			]
		);
		$this->add_control(
			'term_couses_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid.effective-layout  .course-term a,{{WRAPPER}} .thim-course-grid.gym-layout .course-term a' => 'color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['grid-effective','grid-gym'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'term_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-course-grid.effective-layout  .course-term a,{{WRAPPER}} .thim-course-grid.gym-layout .course-term a',
				'condition' => array(
					'layout' => ['grid-effective','grid-gym'],
				),
			]
		);
		$this->add_control(
			'couses_date_hedding',
			[
				'label' => esc_html__( 'Date', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
		$this->add_control(
			'date_couses_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid.therapist-layout  .time' => 'color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
		$this->add_control(
			'date_couses_bgcolor',
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-grid.therapist-layout  .time' => 'background-color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'date_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-course-grid.therapist-layout  .time',
				'condition' => array(
					'layout' => ['grid-therapist'],
				),
			]
		);
        $this->end_controls_tab();
		// end normal tab

		// start hover tab
        $this->start_controls_tab(
            'item_style_hover',
            [
                'label' => esc_html__( 'Hover', 'coaching' ),
            ]
        );
 		$this->add_control(
			'item_background_hover',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-content:hover' => 'background-color: {{VALUE}};' 

				],
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);

		$this->add_control(
			'title_color_hover',
			[
				'label'     => esc_html__( 'Title Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-title a:hover,{{WRAPPER}} .thim-carousel-course-categories .item:hover .title a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-carousel-course-categories-tabs .thim-course-slider .item.active .title a,{{WRAPPER}} .thim-carousel-course-categories-tabs .thim-course-slider .item:hover .title a' => 'color: {{VALUE}};'

				],
			]
		);
		$this->add_control(
			'arrow_active',
			[
				'label'     => esc_html__( 'Arrow Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-carousel-course-categories-tabs .thim-course-slider .item.active:after' => 'background-color: {{VALUE}};'
 
				],
				'condition' => array(
					'layout' => 'tab-slider',
				),
			]
		); 
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-item:hover',
				'condition' => array(
					'layout' => ['slider','grid','grid-bussiness','grid-effective','grid-gym','grid-therapist','grid-home5'],
				),
			]
		);
		

        $this->end_controls_tab();
		// end hover tab
		$this->end_controls_tabs();
		$this->course_read_more_style();
		$this->end_controls_section();
	}
	protected function courses_nav_style(){ 
		$this->start_controls_section(
			'course_nav_settings',
			[
				'label' => esc_html__( 'Nav', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'layout' => ['slider'],
				),
			]
		);
		// start tab for item
		$this->start_controls_tabs(
            'style_item_nav_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'item_nav_style_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
		$this->add_responsive_control(
			'carousel_post__nav_vertical_offset',
			array(
				'label'       => esc_html__( 'Vertical align', 'coaching' ),
				'type'        => Controls_Manager::NUMBER,
				'label_block' => false,
				'min'         => - 500,
				'max'         => 500,
				'step'        => 1,
				'selectors'   => array(
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div' => '-webkit-transform: translateY({{VALUE}}px); -ms-transform: translateY({{SIZE}}px); transform: translateY({{SIZE}}px);',
				),
			)
		);
		$this->add_responsive_control(
			'carousel_post__nav_color_normal',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div i' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_bg_color_normal',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div' => 'background-color: {{VALUE}}'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_font_size',
			[
				'label'      => esc_html__( 'Font Size', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		

		$this->add_responsive_control(
			'carousel_post__nav_width',
			[
				'label'      => esc_html__( 'Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_height',
			[
				'label'      => esc_html__( 'Height', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'carousel_post__nav_box_shadow_normal',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), 
			[
				'name'     => 'carousel_post__nav_border_normal',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div',
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_tab();
		// end normal tab

		// start hover tab
        $this->start_controls_tab(
            'item_nav_style_hover',
            [
                'label' => esc_html__( 'Hover', 'coaching' ),
            ]
        );
		$this->add_responsive_control(
			'carousel_post__nav_color_hover',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div i:hover' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_bg_color_hover',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-course-carousel .owl-controls .owl-nav > div:hover' => 'background-color: {{VALUE}}'
				],
			]
		);
		$this->end_controls_tab();
		// end normal tab
		$this->end_controls_tabs();
		// end normal tab
		$this->end_controls_section();
	}
	protected function course_read_more_style(){ 
		$this->add_control(
			'course_style_button',
			[
				'label' => esc_html__( 'Button', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		// start tab for item
		$this->start_controls_tabs(
            'course_style_tabs2',
        );

        // start normal tab
        $this->start_controls_tab(
            'course__style_normal2',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
				'condition' => array(
					'layout' => ['megamenu'],
				),
				
            ]
        );
		$this->add_control(
			'course_style_bt_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-readmore' => 'color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_control(
			'course_style_bt_bgcolor', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-readmore' => 'background: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'course_style_bt_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .course-readmore',
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'course_item_border',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-readmore',
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_responsive_control(
			'bt_item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .course-readmore' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'course_item_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' =>'{{WRAPPER}} .course-readmore',
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_responsive_control(
			'course_item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .course-readmore' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					
  				],
				  'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_responsive_control(
			'course_item_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .course-readmore' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
  				],
				  'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'course__style_hover2',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_control(
			'course_style_bt_color_hover', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-readmore:hover' => 'color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);
		$this->add_control(
			'course_style_bt_bgcolor_hover', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .course-readmore:hover' => 'background: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		); 
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'course_item_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .course-readmore:hover',
				'condition' => array(
					'layout' => ['megamenu'],
				),
			]
		);

		$this->end_controls_tab();
		// end hover tab
		$this->end_controls_tabs();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		$settings['grid-options']['columns'] = $settings['columns'];
		$settings['slider-options']['show_pagination'] = $settings['show_pagination'];
		$settings['slider-options']['show_navigation'] = $settings['show_navigation'];
		$settings['slider-options']['item_visible'] = $settings['item_visible'];
		$settings['thumbnail_width'] = isset( $settings['thumbnail_width'] ) ? $settings['thumbnail_width']['size'] : '';
		$settings['thumbnail_height'] = isset( $settings['thumbnail_height'] ) ? $settings['thumbnail_height']['size'] : '';

		$args                 = array();
		$args['before_title'] = '<div class="thim-widget-courses"><h3 class="widget-title">';
		$args['after_title']  = '</h3></div>';

		thim_get_widget_template( $this->get_base(), array( 'instance' => $settings, 'args' => $args ), $settings['layout'] );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Courses_El() );
