<?php

namespace Elementor;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_List_Post_El extends Widget_Base {

	public function get_name() {
		return 'thim-list-post';
	}

	public function get_title() {
		return esc_html__( 'Thim: List Post', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-list-post';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	// list image size
	function get_image_sizes( $size = '' ) {

		global $_wp_additional_image_sizes;

		$sizes                        = array();
		$get_intermediate_image_sizes = get_intermediate_image_sizes();

		// Create the full array with sizes and crop info
		foreach ( $get_intermediate_image_sizes as $_size ) {

			if ( in_array( $_size, array( 'thumbnail', 'medium', 'large' ) ) ) {

				$sizes[$_size]['width']  = get_option( $_size . '_size_w' );
				$sizes[$_size]['height'] = get_option( $_size . '_size_h' );
				$sizes[$_size]['crop']   = (bool) get_option( $_size . '_crop' );

			} elseif ( isset( $_wp_additional_image_sizes[$_size] ) ) {

				$sizes[$_size] = array(
					'width'  => $_wp_additional_image_sizes[$_size]['width'],
					'height' => $_wp_additional_image_sizes[$_size]['height'],
					'crop'   => $_wp_additional_image_sizes[$_size]['crop']
				);

			}

		}

		// Get only 1 size if found
		if ( $size ) {

			if ( isset( $sizes[$size] ) ) {
				return $sizes[$size];
			} else {
				return false;
			}

		}

		return $sizes;
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {

		$list_image_size            = $this->get_image_sizes();
		$list_image_size['health2'] = array(
			'width'  => '270',
			'height' => '150',
			'crop'   => false
		);
		$list_image_size['custom']  = array(
			'width'  => '50',
			'height' => '50',
			'crop'   => false
		);

		$image_size                 = array();
		$image_size['none']         = esc_html__( 'No Image', 'coaching' );
		$image_size['custom_image'] = esc_html__( 'Custom Image', 'coaching' );
		$image_size['custom_size']  = esc_html__( 'Custom Size', 'coaching' );
		if ( is_array( $list_image_size ) && !empty( $list_image_size ) ) {
			foreach ( $list_image_size as $key => $value ) {
				if ( $value['width'] && $value['height'] ) {
					$image_size[$key] = $value['width'] . 'x' . $value['height'];
				} else {
					$image_size[$key] = $key;
				}
			}
		}

		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'List Post', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'coaching' ),
				'default'     => esc_html__( 'From Blog', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'cat_id',
			[
				'label'   => esc_html__( 'Select Category', 'coaching' ),
				'default' => 'none',
				'type'    => Controls_Manager::SELECT,
				'options' => thim_get_cat_taxonomy( 'category', array( 'all' => esc_html__( 'All', 'coaching' ) )  ),
			]
		);

		$this->add_control(
			'number_posts',
			[
				'label'   => esc_html__( 'Number Post', 'coaching' ),
				'default' => '4',
				'type'    => Controls_Manager::NUMBER,
			]
		);

		$this->add_control(
			'show_description',
			[
				'label'   => esc_html__( 'Show Description', 'coaching' ),
				'default' => true,
				'type'    => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Order by', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'popular' => esc_html__( 'Popular', 'coaching' ),
					'recent'  => esc_html__( 'Date', 'coaching' ),
					'title'   => esc_html__( 'Title', 'coaching' ),
					'random'  => esc_html__( 'Random', 'coaching' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order by', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__( 'ASC', 'coaching' ),
					'desc' => esc_html__( 'DESC', 'coaching' )
				],
			]
		);

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Layout', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'base',
				'options' => [
					"base"            => esc_html__( "No Style", 'coaching' ),
					"life_homepage"   => esc_html__( "Life Normal Style", 'coaching' ),
					"health_homepage" => esc_html__( "Health Normal Style", 'coaching' ),
					"health_slider"   => esc_html__( "Health Slider Style", 'coaching' ),
					"health_2"        => esc_html__( "Health 2 Style", 'coaching' ),
					"effective"       => esc_html__( "Effective Style", 'coaching' ),
					"health_sticky"   => esc_html__( "Health Sticky Style", 'coaching' ),
					"sidebar"         => esc_html__( "Sidebar", 'coaching' ),
					"gym"             => esc_html__( "Gym style", 'coaching' ),
					"therapist"       => esc_html__( "Therapist style", 'coaching' ),
					"home5"           => esc_html__( "Home5 style", 'coaching' ),
				],
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'   => esc_html__( 'Select Image Size', 'coaching' ),
				'default' => 'none',
				'type'    => Controls_Manager::SELECT,
				'options' => $image_size,
			]
		);

		$this->add_control(
			'size_w',
			[
				'label'   => esc_html__( 'Image width', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => '400'
			]
		);

		$this->add_control(
			'size_h',
			[
				'label'   => esc_html__( 'Image height', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => '400'
			]
		);

		$this->add_control(
			'feature_text',
			[
				'label'       => esc_html__( 'Feature Text', 'coaching' ),
				'default'     => esc_html__( 'Sticky Post', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'condition'   => [
					'style' => [ 'health_sticky' ]
				]
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => esc_html__( 'Link All Posts', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'condition'   => [
					'style' => [ 'life_homepage' ]
				]
			]
		);

		$this->add_control(
			'text_link',
			[
				'label'       => esc_html__( 'Text All Posts', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'condition'   => [
					'style' => [ 'life_homepage' ]
				]
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'     => esc_html__( 'Autoplay', 'coaching' ),
				'default'   => false,
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'style' => [ 'health_slider', 'home5' ]
				]
			]
		);

		$this->add_control( 
			'autoplayTimeout',
			[
				'label'     => esc_html__( 'Autoplay Timeout', 'coaching' ),
				'type'      => Controls_Manager::NUMBER,
				'condition' => [
					'style' => [ 'health_slider', 'home5' ]
				]
			]
		);


		$this->end_controls_section();
		$this->start_controls_section(
			'list_post_header_section',
			array(
				'label'     => esc_html__( 'Header', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'list__header_title_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts-header .widget-title' => 'color: {{VALUE}};',
 
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_title_header_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-posts-header .widget-title',
			]
		);
		$this->add_responsive_control(
			'item_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .thim-list-posts-header' => 'text-align: {{VALUE}};',
                ],
			]
		);
		$this->add_responsive_control( 
			'testimonials_headding_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts-header .widget-title' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_section();
		$this->list_post_style_sc();
		$this->list_post__slider_nav_sc();
		$this->list_post_button_view_all();
	}
	protected function list_post_style_sc(){  
		$this->start_controls_section(
			'list_post_section',
			array(
				'label'     => esc_html__( 'List Post', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'list_post_item_h',
			[
				'label' => esc_html__( 'Item', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'style' => ['base','life_homepage','health_homepage','health_2'],
				),
			]
		);
		$this->add_control(
			'list_item_bg_color', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .item-post' => 'background-color: {{VALUE}}!important;',
				],
				'condition' => array(
					'style' => ['home5'],
				),
			]
		);
		$this->add_responsive_control(
			'list_item__border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .item-post' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => array(
					'style' => ['home5'],
				),
			]
		);
		$this->add_responsive_control(
			'list_post_item_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .base .item-post,{{WRAPPER}} .item-post article,{{WRAPPER}} .thim-list-posts-health2 article'  => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
				],
				'condition' => array(
					'style' => ['base','life_homepage','health_homepage','health_2'],
				),
			]
		);

		$this->add_control(
			'list_post_title_h',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		// start tab for item
		$this->start_controls_tabs(
            'style_item_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'litem_style_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
		$this->add_control(
			'list_title_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts .article-title-wrapper a' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-posts .entry-title a,{{WRAPPER}} .thim-list-posts.home5 .thim-list-posts-slider  .entry-title a' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_responsive_control(
			'list_post_title_space_top',
			[
				'label'      => esc_html__( 'Space Top', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts .article-title-wrapper h5,{{WRAPPER}} .entry-title a,{{WRAPPER}} .entry-title,
					{{WRAPPER}} .thim-list-posts.home5 .thim-list-posts-slider  .entry-title' => 'margin-top: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->add_responsive_control(
			'list_post_title_space_bottom',
			[
				'label'      => esc_html__( 'Space Bottom', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts .article-title-wrapper h5,{{WRAPPER}} .entry-title a,{{WRAPPER}} .entry-title,
					{{WRAPPER}} .thim-list-posts.home5 .thim-list-posts-slider  .entry-title' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_title_s1_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-posts .article-title-wrapper a,{{WRAPPER}} .thim-list-posts .entry-title a,
				{{WRAPPER}} .thim-list-posts.home5 .thim-list-posts-slider .item-post .entry-content .main-content .entry-header .entry-title a',
			]
		);
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'litem_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			'list_title_color_hover', 
			[
				'label'     => esc_html__( 'Title Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts .article-title-wrapper a:hover' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .thim-list-posts .entry-title a:hover,{{WRAPPER}} .thim-list-posts.home5 .thim-list-posts-slider  .entry-title a:hover' => 'color: {{VALUE}} !important;',
 
				],
				
			]
		);
		$this->end_controls_tab();
		// end hover tab
		
		$this->end_controls_tabs();
		$this->add_responsive_control(
			'list_titel_item_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ), 
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .entry-content .entry-header' => 'text-align: {{VALUE}};',
                ],
				'condition' => array(
					'style' => ['health_slider','effective','gym'],

				),
			]
		);
		$this->add_control(
			'list_post_des_h',
			[
				'label' => esc_html__( ' Description', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'show_description' => 'yes',
				),
			]
		);
		$this->add_control(
			'list_des_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts .description,{{WRAPPER}} .thim-excerpt,{{WRAPPER}} .article-title-wrapper' => 'color: {{VALUE}};',
				],
				'condition' => array(
					'show_description' => 'yes',
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_des_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-posts .description,{{WRAPPER}} .thim-excerpt,{{WRAPPER}} .article-title-wrapper',
				'condition' => array(
					'show_description' => 'yes',
				),
			]
		);
		$this->add_responsive_control(
			'list_post_des_space_top',
			[
				'label'      => esc_html__( 'Space Top', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts .description,{{WRAPPER}} .thim-excerpt,{{WRAPPER}} .article-title-wrapper' => 'margin-top: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'show_description' => 'yes',
					'style' =>['life_homepage','health_slider','effective','gym','health_2','sidebar','therapist','home5']
				),
			]
		);
		$this->add_responsive_control( 
			'list_post_des_space',
			[
				'label'      => esc_html__( 'Space Bottom', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts .description,{{WRAPPER}} .thim-excerpt,{{WRAPPER}} .article-title-wrapper' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'show_description' => 'yes',
					'style' =>['life_homepage','health_slider','effective','gym','health_2','sidebar','therapist','home5']
				),
			]
		);
		$this->add_control(
			'list_post_metabox_h',
			[
				'label' => esc_html__( ' Meta box', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'style' => ['base','life_homepage','health_homepage','health_2','health_slider','effective','sidebar','therapist','home5'],
				),
			]
		);
		$this->add_control(
			'list_title_date_color', 
			[
				'label'     => esc_html__( 'Date Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts .article-title-wrapper .article-date span' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-list-posts .entry-header .date-meta' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-list-posts.health_2 .item-post .date-meta' => 'color: {{VALUE}};',
				],
				'condition' => array(
					'style' => ['base','health_homepage','health_2','sidebar'],
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_date_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-posts .article-date span,{{WRAPPER}} .thim-list-posts .entry-header .date-meta,{{WRAPPER}} .thim-list-posts.health_2 .item-post .date-meta,
				{{WRAPPER}} .entry-meta li span,{{WRAPPER}} .entry-meta li a,{{WRAPPER}} .entry-meta li span a,{{WRAPPER}} .entry-meta li,{{WRAPPER}} .entry-meta li span,{{WRAPPER}} .thim-list-posts.home5 li span a,{{WRAPPER}} .thim-list-posts.home5 li i',
				'condition' => array(
					'style' => ['base','health_homepage','health_2','health_slider','sidebar','therapist','home5'],
				),
			]
		);
		$this->add_responsive_control(
			'list_post_date_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts .article-title-wrapper .article-date' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-posts .entry-header .date-meta' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-posts.health_2 .item-post .date-meta' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-posts .entry-meta li span' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-posts .entry-meta li a' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-posts .entry-meta li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-posts .entry-meta li span a' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => array(
					'style' => ['base','life_homepage','health_homepage','health_slider','sidebar','therapist','home5'],
				),
			]
		);
		$this->add_control(
			'list_meta_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .entry-meta li span,{{WRAPPER}} .thim-list-posts .entry-meta span' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .entry-meta li a' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .entry-meta li' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .entry-meta li span a' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .entry-meta li i' => 'background-image: linear-gradient(to left,{{VALUE}},{{VALUE}}),linear-gradient(to bottom,#848484,#848484) !important;',
				],
				'condition' => array(
					'style' => ['life_homepage','health_slider','effective','therapist','home5'],
				),
			]
		);
		$this->add_control(
			'list_post_cats_h',
			[
				'label' => esc_html__( 'Category', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'style' => ['health_slider','health_2'],
				),
			]
		);
		$this->add_control(
			'list_post_gym_date_h',
			[
				'label' => esc_html__( 'Date', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'style' => ['gym'],
				),
			]
		);
		$this->add_control(
			'list__cats_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts .entry-category a,{{WRAPPER}} .thim-list-posts.health_2 .item-post .article-image .entry-category a,
					{{WRAPPER}} .thim-list-posts-gym .date-meta div' => 'color: {{VALUE}};',
 
				],
				'condition' => array(
					'style' => ['health_slider','health_2','gym'],
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_cats_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-posts .entry-category a,{{WRAPPER}} .thim-list-posts.health_2 .item-post .article-image .entry-category a,
				{{WRAPPER}} .thim-list-posts-gym .date-meta div',
				'condition' => array(
					'style' => ['health_slider','health_2','gym'],
				),
			]
		);
		$this->add_control(
			'list_meta_bag_cat_color',  
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts .entry-category,{{WRAPPER}} .thim-list-posts-gym .date-meta' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .thim-list-posts.health_2 .item-post .article-image .entry-category' => 'background-color: {{VALUE}};',
				],
				'condition' => array(
					'style' => ['health_slider','health_2','gym'],
				),
			]
		);
		$this->add_responsive_control(
			'list_meta_item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts .entry-category,{{WRAPPER}} .thim-list-posts.health_2 .item-post .article-image .entry-category,
					{{WRAPPER}} .thim-list-posts-gym .date-meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-posts-gym .item-post .post-image .date-meta' => 'height: auto;  width: auto;',
  				],
				  'condition' => array(
					'style' => ['health_slider','health_2','gym'],
				),
			]
		);
		$this->add_control(
			'list_post_list_bt_h',
			[
				'label' => esc_html__( 'Button', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'style' => ['health_2','gym'],
				),
			]
		);
			// start tab for item
			$this->start_controls_tabs(
				'list_post__btitem_tabs',
			);
	
			// start normal tab
			$this->start_controls_tab(
				'list_post__btstyle_normal2',
				[
					'label' => esc_html__( 'Normal', 'coaching' ),
					'condition' => array(
						'style' => ['health_2','gym'],
					),
				]
			);
			$this->add_control(
				'list_post__bt_color', 
				[
					'label'     => esc_html__( 'Color', 'coaching' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .main-content .learn-more' => 'color: {{VALUE}}!important;',
					],
					'condition' => array(
						'style' => ['health_2','gym'],
					),
				]
			);
			$this->add_group_control( 
				Group_Control_Typography::get_type(),
				[
					'name'     => 'list_post__bt_typography',
					'label'    => esc_html__( 'Typography', 'coaching' ),
					'selector' =>'{{WRAPPER}} .thim-list-posts.health_2 .main-content .learn-more,
					{{WRAPPER}} .thim-list-posts-gym .learn-more',
					'condition' => array(
						'style' => ['health_2','gym'],
					),
				]
			);
	
			$this->end_controls_tab();
			// end normal tab
			// start hover tab
			$this->start_controls_tab(
				'list_post__bt_style_hover2',
				[
					'label' => esc_html__( 'Hover', 'coaching' ),
					'condition' => array(
						'style' => ['health_2','gym'],
					),
				]
			);
			$this->add_control(
				'list_post__bt_color_hover', 
				[
					'label'     => esc_html__( 'Color', 'coaching' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .thim-about-me .right .content-info a:hover,{{WRAPPER}} .main-content .learn-more:hover' => 'color: {{VALUE}}!important;',
					],
					'condition' => array(
						'style' => ['health_2','gym'],
					),
				]
			);
	
			$this->end_controls_tab();
			// end hover tab
			$this->end_controls_tabs();
		$this->end_controls_section();
	}
	protected function list_post_button_view_all(){
		$this->start_controls_section(
			'list_post_viewall_section',
			array(
				'label'     => esc_html__( 'View All Post', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'style' => ['life_homepage'],
				),
			)
		);
		// start tab for item
		$this->start_controls_tabs(
			'list_post__btall_tabs',
		);

		// start normal tab
		$this->start_controls_tab(
			'list_post__btallstyle_normal2',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);
		$this->add_control(
			'list_post__btall_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .life_homepage .readmore a' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_post__btall_bgcolor', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .life_homepage .readmore a' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_post__btall_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .life_homepage .readmore a',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'btall_border',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .life_homepage .readmore a',
			]
		);
		$this->add_responsive_control(
			'list_post_allbt_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .life_homepage .readmore a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'btall_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' =>'{{WRAPPER}} .life_homepage .readmore a',
			]
		);
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'list_post__btall_style_hover2',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			'list_post__btall_color_hover', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .life_homepage .readmore a:hover' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_post__btall_bgcolor_hover', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .life_homepage .readmore a:hover' => 'background: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => '_btall_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .life_homepage .readmore a:hover',
			]
		);
		$this->end_controls_tab();
		// end hover tab
		$this->end_controls_tabs();
		$this->end_controls_section();
	}
	protected function list_post__slider_nav_sc(){
		$this->start_controls_section(
			'list_post_slider_style_nav',
			array(
				'label'     => esc_html__( 'Nav', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'style' => ['health_slider'],
				),
			)
		);
		
		$this->start_controls_tabs( '
		list_post_tabs_item2' 
		);
		$this->start_controls_tab(
			'list_post_tabs_normal',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);
		$this->add_responsive_control(
			'list_post__nav_vertical_offset',
			array(
				'label'       => esc_html__( 'Vertical align', 'coaching' ),
				'type'        => Controls_Manager::NUMBER,
				'label_block' => false,
				'min'         => - 500,
				'max'         => 500,
				'step'        => 1,
				'selectors'   => array(
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div' => '-webkit-transform: translateY({{VALUE}}px); -ms-transform: translateY({{SIZE}}px); transform: translateY({{SIZE}}px);',
				),
			)
		);
		$this->add_responsive_control(
			'list_post__nav_color_normal',
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div i' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'list_post__nav_bg_color_normal',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div' => 'background-color: {{VALUE}}'
				],
			]
		);

		$this->add_responsive_control(
			'list_post__nav_font_size',
			[
				'label'      => esc_html__( 'Font Size', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		

		$this->add_responsive_control(
			'list_post__nav_width',
			[
				'label'      => esc_html__( 'Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->add_responsive_control(
			'list_post__nav_height',
			[
				'label'      => esc_html__( 'Height', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100, 
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'list_post__nav_box_shadow_normal',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-posts-slider .owl-nav > div',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), 
			[
				'name'     => 'list_post__nav_border_normal',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-posts-slider .owl-nav > div',
			]
		);
		$this->add_responsive_control(
			'list_post__nav_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'list_post_tab_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_responsive_control(
			'list_post__nav_color_hover',
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div i:hover' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'list_post__nav_bg_color_hover',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div:hover' => 'background-color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'list_post__nav_boder_color_hover',
			[
				'label'     => esc_html__( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .thim-list-posts-slider .owl-nav > div:hover' => 'border-color: {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'list_post__nav_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-posts-slider .owl-nav > div:hover',
			]
		);
		$this->end_controls_tab();
		// end normal tab
		$this->end_controls_tabs();
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display(); 

 		$args                 = array();
		$args['before_title'] = '<div class="thim-list-posts-header"><h3 class="widget-title">';
		$args['after_title']  = '</h3></div>';

		$layout = isset($settings['style']) ? $settings['style'] : 'base';

		if($layout == 'life_homepage' || $layout == 'health_homepage' || $layout == 'sidebar'){
			$layout = 'base';
 		}

		thim_get_widget_template( $this->get_base(), array( 'instance' => $settings, 'args' => $args ), $layout );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_List_Post_El() );
