<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) { 
	exit;
}

class Thim_Plan_El extends Widget_Base {

	public function get_name() {
		return 'thim-plan';
	}

	public function get_title() { 
		return esc_html__( 'Thim: Plan', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-plan';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Plan', 'coaching' )
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'panel_title',
            [
                'label' => esc_html__('Panel Title', 'coaching'),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'panel_body',
            [
                'label' => esc_html__('Panel Body', 'coaching'),
                'type'        => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'panel',
            [
                'label'       => esc_html__( 'List', 'coaching' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ panel_title }}}',
                'separator'   => 'before'
            ]
        );

		$this->add_control(
			'date_type',
			[
				'type'        => Controls_Manager::TEXT,
                'label' => esc_html__('Date Type','coaching'),
                'label_block' => true
			]
		);

        $this->add_control(
            'autoplay',
            [
                'type'    => Controls_Manager::SWITCHER,
                'label' => esc_html__('Autoplay', 'coaching'),
                'default' => false
            ]
        );

        $this->add_control(
            'autoplayTimeout',
            [
                'type'        => Controls_Manager::NUMBER,
                'label' => esc_html__('Autoplay Timeout', 'coaching'),
                'default' => '',
                'description' => esc_html__( 'Set time out for slide auto play (millisecond).', 'coaching' ),
            ]
        );

		$this->end_controls_section();
        $this->plan_tabs_styles_sc(); 
        
	}
    protected function plan_tabs_styles_sc(){
        $this->start_controls_section(
			'plan_number_section',
			[
				'label' => esc_html__( 'Number', 'coaching' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		); 
        $this->add_control(
            'plan_number_color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .circle-border .circle-inner p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'plan_number_bg_color',
            [
                'label' => esc_html__( 'Background', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .circle-border .circle-inner' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'plan_number_typography',
				'selector' => '{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .circle-border .circle-inner p',
			]
		);
        $this->add_responsive_control( 
			'plan_number__width',
			[
				'label'      => esc_html__( 'Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .circle-border .circle-inner' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->add_responsive_control(
			'plan_number__height',
			[
				'label'      => esc_html__( 'Height', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .circle-border .circle-inner' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
			'plan_content_section',
			[
				'label' => esc_html__( 'Content', 'coaching' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		); 
        $this->add_control(
			'plan_style_title',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
            'plan_content_color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .title' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'plan_content_typography',
				'selector' => '{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .title',
			]
		);
		$this->add_responsive_control(
			'content_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-plan .thim-plan-carousel-container .plan-item .panel-heading .title'  => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);

        $this->add_control(
			'plan_style_des',
			[
				'label' => esc_html__( ' Description', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
            'plan_des_color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim-plan  .panel-body' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), 
			[
				'name' => 'plan_des_typography',
				'selector' => '{{WRAPPER}} .thim-plan  .panel-body',
			]
		);
		$this->add_responsive_control(
			'content_des_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-plan  .panel-body'  => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
        $this->end_controls_section();
    }
    protected function render() {
		$settings = $this->get_settings_for_display();
 		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		) );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Plan_El() );
