<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Podcast_El extends Widget_Base {

    public function get_name() {
		return 'thim-podcast';
	}

	public function get_title() {
		return esc_html__( 'Thim: Podcast', 'coaching' );
	}

	public function get_icon() {
		return 'thim-eicon eicon-headphones';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

    public function get_podcast(){
        $podcast = array();
		$query_args = array(
            'post_type'             => 'post',
            'post_status'           => 'publish',
            'posts_per_page'        => -1,
            'ignore_sticky_posts'   => true,
            'tax_query'   => array(
                array(
                    'taxonomy' => 'post_format',
                    'field' => 'slug',
                    'operator' => 'IN',
                    'terms' => array( 'post-format-audio' )
                ),
            )
        );
        $query_podcast = new \WP_Query( $query_args );

        while ( $query_podcast->have_posts() ) : $query_podcast->the_post();
            $thim_audio_mp3 = get_post_meta( get_the_ID(), 'thim_audio_mp3', true );

            if($thim_audio_mp3){
                $podcast[get_the_ID()] = get_the_title();
            }

        endwhile;

        wp_reset_query();

		return $podcast;
    }

    protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Podcast', 'coaching' )
			]
		);

        $this->add_control(
			'podcast',
			[
				'label'    => esc_html__('Select Podcast', 'barber'),
				'type'     => Controls_Manager::SELECT,
				'options'  => $this->get_podcast(),
			]
		);

        $this->add_responsive_control(
			'socialicon_list_align',
			array(
				'label'     => esc_html__( 'Alignment', 'thim-elementor-kit' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'thim-elementor-kit' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'thim-elementor-kit' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'thim-elementor-kit' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}} .thim-widget-podcast .audio-player' => 'text-align: {{VALUE}};',
				),
			)
		);

        $this->add_control(
			'icon_prev',
			array(
				'label'            => esc_html__( 'Icon Prev', 'thim-elementor-kit' ),
				'type'             => Controls_Manager::ICONS,
				'skin'             => 'inline',
				'label_block'      => false,
				'default'          => array(
					'value'   => 'fas fa-angle-double-left',
					'library' => 'Font Awesome 5 Brands',
				),
			)
		);

        $this->add_control(
			'icon_next',
			array(
				'label'            => esc_html__( 'Icon Next', 'thim-elementor-kit' ),
				'type'             => Controls_Manager::ICONS,
				'skin'             => 'inline',
				'label_block'      => false,
				'default'          => array(
					'value'   => 'fas fa-angle-double-right',
					'library' => 'Font Awesome 5 Brands',
				),
			)
		);

        $this->add_control(
			'icon_play',
			array(
				'label'            => esc_html__( 'Icon Play', 'thim-elementor-kit' ),
				'type'             => Controls_Manager::ICONS,
				'skin'             => 'inline',
				'label_block'      => false,
				'default'          => array(
					'value'   => 'fas fa-headphones',
					'library' => 'Font Awesome 5 Brands',
				),
			)
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'podcast_style',
			array(
				'label'     => esc_html__( 'Image', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);

        $this->add_responsive_control(
			'image_width',
			[
				'label'      => esc_html__( 'Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 300,
						'step' => 10,
					],
				],
//				'default'    => 200,
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-podcast .audio-player img' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

        $this->add_responsive_control(
			'image_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-podcast .audio-player img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);

        $this->add_responsive_control(
			'image_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-widget-podcast .audio-player img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'text_style',
			array(
				'label'     => esc_html__( 'Text', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);

        $this->add_control(
			'title_h',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .audio-player__top__title',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .audio-player__top__title' => 'color: {{VALUE}};',

				],
			]
		);

        $this->add_responsive_control(
			'title_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .audio-player__top__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'author_h',
			[
				'label' => esc_html__( 'Author', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'author_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .audio-player__top__author a',
			]
		);

        $this->add_control(
			'author_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .audio-player__top__author a' => 'color: {{VALUE}};',

				],
			]
		);

        $this->add_responsive_control(
			'author_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .audio-player__top__author' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'duration_h',
			[
				'label' => esc_html__( 'Duration', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'duration_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .audio-player__bottom__duration',
			]
		);

        $this->add_control(
			'duration_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .audio-player__bottom__duration' => 'color: {{VALUE}};',

				],
			]
		);

        $this->add_responsive_control(
			'duration_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .audio-player__bottom__duration' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'icon_style',
			array(
				'label'     => esc_html__( 'Icon', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);

        $this->add_responsive_control(
			'icon_font_size',
			[
				'label'      => esc_html__( 'Font Size', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .audio-player__bottom__icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Icon Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .audio-player__bottom__icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .audio-player__bottom__icon svg path' => 'fill: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .audio-player__bottom__icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

    }

    protected function render() {
        wp_enqueue_script( 'thim-amplitude');

		$settings   = $this->get_settings_for_display();

        $podcast = $settings['podcast'];

        if( !empty($podcast) ):
        ?>
        <div class="thim-widget-podcast">
            <div id="audio-player" class="audio-player" data-audio="<?php echo get_post_meta($podcast, 'thim_audio_url', true); ?>">
                <div class="audio-player__top">
                    <div id="song-saved"></div>
                    <?php echo get_the_post_thumbnail($podcast, array(300, 300)); ?>
                    <h4 class="audio-player__top__title"><?php echo get_the_title($podcast) ?></h4>
                    <h5 class="audio-player__top__author">
                        <?php printf( '<a href="%1$s">%2$s</a>',
                            esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                            esc_html( get_the_author() )
                        ); ?>
                    </h5>
                </div>
                <div class="audio-player__bottom">
                    <div class="audio-player__bottom__icon">
                        <div class="amplitude-prev">
                            <?php Icons_Manager::render_icon( $settings['icon_prev'], array( 'aria-hidden' => 'true' ) ); ?>
                        </div>
                        <div class="amplitude-play-pause">
                            <?php Icons_Manager::render_icon( $settings['icon_play'], array( 'aria-hidden' => 'true' ) ); ?>
                        </div>
                        <div class="amplitude-next">
                            <?php Icons_Manager::render_icon( $settings['icon_next'], array( 'aria-hidden' => 'true' ) ); ?>
                        </div>
                    </div>
                    <div class="audio-player__bottom__range">
					    <input type="range" id="song-percentage-played" class="amplitude-song-slider audio-player__box__player__range" step=".1"/>
                        <div class="audio-player__bottom__duration">
                            <span class="amplitude-current-time"></span>
                            <span class="amplitude-duration-time"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        endif;
    }

}
