<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Services_El extends Widget_Base {

	public function get_name() {
		return 'thim-services';
	}

	public function get_title() {
		return esc_html__( 'Thim: Services', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-services';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Services', 'coaching' )
			]
		);

        $this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'base'            => esc_html__( 'Default', 'coaching' ),
					'slide-2'        => esc_html__( 'Slider Business Coaching', 'coaching' ),
                    'grid'          => esc_html__( 'Grid', 'coaching' ),
				],
				'default' => 'base'
			]
		);

        $this->add_responsive_control(
			'column',
			[
				'label'     => esc_html__( 'Columns', 'coaching' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '3',
				'options'   => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'selectors' => array(
					'{{WRAPPER}}' => '--thim-service-columns: repeat({{VALUE}}, 1fr)',
				),
                'condition' => array(
					'layout'    => 'grid'
                )
			]
		);
		$this->add_responsive_control(
			'columns',
			[
				'label'     => esc_html__('Columns', 'coaching'),
				'type'      => Controls_Manager::SELECT,
				'default'   => '3',
				'options'   => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'condition' => array(
					'layout'    =>  'slide-2'
				)
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'service_title',
            [
                'label'       =>  esc_html__( 'Title', 'coaching' ),
                'type'    => Controls_Manager::TEXT,

            ]
        );

        $repeater->add_control(
            'service_desc',
            [
                'label'       =>  esc_html__( 'Description', 'coaching' ),
                'type'    => Controls_Manager::TEXTAREA,
            ]
        );

        $repeater->add_control(
            'service_link',
            [
                'label'       =>  esc_html__( 'Link', 'coaching' ),
                'type'        => Controls_Manager::TEXT,

            ]
        );

        $repeater->add_control(
            'service_link_text',
            [
                'label'       =>  esc_html__( 'Link Text', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
                'condition' => array(
					'service_link!'    => ''
                )
            ]
        );

        $repeater->add_control(
            'service_image',
            [
                'label'       =>  esc_html__( 'Image', 'coaching' ),
                'type'        => Controls_Manager::MEDIA,

            ]
        );

        $repeater->add_control(
            'service_bg_color',
            [
                'label' => esc_html__( 'Background Overlay Color', 'coaching' ),
                'type'  => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'service',
            [
                'label'       => esc_html__( 'List', 'coaching' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ service_title }}}',
                'separator'   => 'before',
            ]
        );

        $this->add_control(
			'icon',
			array(
				'label'       => esc_html__( 'Icon Read More', 'coaching' ),
				'type'        => Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			)
		);

		$this->add_control(
			'icon_spacing',
			array(
				'label'     => esc_html__( 'Icon Spacing (px)', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max' => 50,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore i' => 'margin-left: {{SIZE}}{{UNIT}};',
				),
				'condition' => array( 'icon[value]!' => '' ),
			)
		);


		$this->end_controls_section();
        $this->register_section_item();
        $this->register_section_title();
        $this->register_section_description();
        $this->register_section_readmore();
	}
    protected function register_style_typo_color_margin( string $prefix_name, string $selector ) {
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => $prefix_name . '_typography',
				'selector' => "{{WRAPPER}} $selector",
			)
		);

		$this->add_responsive_control(
			$prefix_name . '_margin',
			array(
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					"{{WRAPPER}} $selector" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			$prefix_name . '_color',
			array(
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					"{{WRAPPER}} $selector" => 'color: {{VALUE}};',
				),
			)
		);

        $this->add_control(
			$prefix_name . '_color_hover',
			array(
				'label'     => esc_html__( 'Color Hover', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					"{{WRAPPER}} $selector:hover" => 'color: {{VALUE}};',
				),
			)
		);
	}
    protected function register_section_item() {
        $this->start_controls_section(
			'item_style',
			array(
				'label' => esc_html__( 'Item', 'coaching' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
        $this->add_responsive_control(
			'item_align',
			array(
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content' => 'text-align: {{VALUE}};',
				),
			)
		);
        $this->add_responsive_control(
			'item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default'    => array(
					'top'    => 0,
					'right'  => 30,
					'bottom' => 24,
					'left'   => 30,
					'unit'   => 'px',
				),
				'selectors'  => [
					'{{WRAPPER}} .thim-service-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'item_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .event-item' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'item_border',
				'selector' => '{{WRAPPER}} .event-item',
			)
		);
        $this->end_controls_section();
    }
    protected function register_section_title() {
        $this->start_controls_section(
			'title_style',
			array(
				'label' => esc_html__( 'Title', 'coaching' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
        $this->register_style_typo_color_margin( 'item_title', '.thim-service-content__title' );
        $this->end_controls_section();
    }
    protected function register_section_description() {
        $this->start_controls_section(
			'description_style',
			array(
				'label' => esc_html__( 'Description', 'coaching' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
        $this->register_style_typo_color_margin( 'item_description', '.thim-service-content__description' );
        $this->end_controls_section();
    }
    protected function register_section_readmore() {
        $this->start_controls_section(
			'readmore_style',
			array(
				'label' => esc_html__( 'Read More', 'coaching' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'readmore_layout',
			array(
				'label'     => esc_html__( 'Display', 'thim-elementor-kit' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'block'        => array(
						'title' => esc_html__( 'Default', 'thim-elementor-kit' ),
						'icon'  => 'eicon-editor-list-ul',
					),
					'inline-block' => array(
						'title' => esc_html__( 'Inline', 'thim-elementor-kit' ),
						'icon'  => 'eicon-ellipsis-h',
					),
				),
				'default'   => 'inline-block',
				'toggle'    => true,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore ' => 'display: {{VALUE}};',
				),
			)
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'read_more_typography',
				'selector' => '{{WRAPPER}} .thim-service-content__readmore',
			)
		);
		$this->add_responsive_control(
			'read_more_padding',
			array(
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .thim-service-content__readmore' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'read_more_margin',
			array(
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .thim-service-content__readmore' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'read_more_border',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-service-content__readmore',
				'exclude'  => array( 'color' ),
			)
		);
		$this->start_controls_tabs(
			'read_more_color_tabs'
		);
		$this->start_controls_tab(
			'read_more_color_tab',
			array(
				'label' => esc_html__( 'Normal', 'coaching' ),
			)
		);
		$this->add_control(
			'read_more_color',
			array(
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore' => 'color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'read_more_bg_color',
			array(
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'read_more_border_color',
			array(
				'label'     => esc_html__( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore' => 'border-color: {{VALUE}};',
				),
			)
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'read_more_color_hover_tab',
			array(
				'label' => esc_html__( 'Hover', 'coaching' ),
			)
		);
		$this->add_control(
			'read_more_color_hover',
			array(
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore:hover' => 'color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'read_more_bg_color_hover',
			array(
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore:hover' => 'background-color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'read_more_border_color_hover',
			array(
				'label'     => esc_html__( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-service-content__readmore:hover' => 'border-color: {{VALUE}};',
				),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
    }
	protected function render() {
		$settings = $this->get_settings_for_display();
 		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		) );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Services_El() );
