<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Tabs_Slider_El extends Widget_Base {

	public function get_name() {
		return 'thim-tabs-thumbnail-slider';
	}

	public function get_title() {
		return esc_html__( 'Thim: Tabs Slider', 'coaching' );
	}

	protected function get_html_wrapper_class() {
		return 'thim-widget-tabs-slider';
	}

	public function get_icon() {
		return 'thim-eicon eicon-slideshow';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_keywords() {
		return [
			'thim',
			'tab',
			'tabs',
			'slide',
		];
	}

	public function get_script_depends() {
		return [ 'thim-slick' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Content', 'coaching' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'   => esc_html__( 'Title', 'coaching' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title', 'coaching' ),
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => esc_html__( 'Sub Title', 'coaching' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__( 'Sub title', 'coaching' ),
				'label_block' => true
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_image',
			[
				'label' => esc_html__( 'Image', 'coaching' ),
				'type'  => Controls_Manager::MEDIA,

			]
		);

		$repeater->add_control(
			'item_title',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type'  => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'item_sub_heading',
			[
				'label'       => esc_html__( 'Sub Title', 'coaching' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$repeater->add_control(
			'item_icon',
			[
				'label'       => esc_html__( 'Select Icon:', 'coaching' ),
				'type'        => Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->add_control(
			'item',
			[
				'label'       => esc_html__( 'Item', 'coaching' ),
				'type'        => Controls_Manager::REPEATER,
				'default'     => [
					[
						'item_title'       => esc_html__( 'Analysis & Research', 'coaching' ),
						'item_sub_heading' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 'coaching' ),
						'item_image'       => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'item_title'       => esc_html__( 'Project Execution', 'coaching' ),
						'item_sub_heading' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 'coaching' ),
						'item_image'       => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'item_title'       => esc_html__( 'Project Launch', 'coaching' ),
						'item_sub_heading' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 'coaching' ),
						'item_image'       => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
				],
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ item_title }}}',
				'separator'   => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'extra_option',
			[
				'label' => esc_html__( 'Extra Options', 'coaching' ),
			]
		);

		$this->add_control(
			'show_number_item',
			[
				'label'     => esc_html__( 'Enable Number Item', 'coaching' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'label_on'  => esc_html__( 'Show', 'coaching' ),
				'label_off' => esc_html__( 'Hide', 'coaching' ),
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label'     => esc_html__( 'Auto Play', 'coaching' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'label_on'  => esc_html__( 'On', 'coaching' ),
				'label_off' => esc_html__( 'Off', 'coaching' ),
			]
		);

		$this->end_controls_section();

		$this->_register_section_layout_style();
		$this->_register_section_header_style();
		$this->_register_section_item_style();
	}

	protected function register_style_typo_color_margin( string $prefix_name, string $selector ) {
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => $prefix_name . '_typography',
				'selector' => "{{WRAPPER}} $selector",
			)
		);

		$this->add_responsive_control(
			$prefix_name . '_margin',
			array(
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					"{{WRAPPER}} $selector" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			$prefix_name . '_color',
			array(
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					"{{WRAPPER}} $selector" => 'color: {{VALUE}};',
				),
			)
		);
	}

	protected function _register_section_layout_style() {
		$this->start_controls_section(
			'layout_style_section',
			array(
				'label' => esc_html__( 'Layout', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'gap',
			array(
				'label'      => esc_html__( 'Gap', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => array(
					'px' => array(
						'max' => 200,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .thim-tabs-slider' => 'gap: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'width_content_left',
			array(
				'label'      => esc_html__( 'Width Left', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'      => array(
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
					'px' => [
						'min'  => 0,
						'max'  => 2000,
						'step' => 5,
					],
				),
				'selectors'  => array(
					'{{WRAPPER}} .thim-tabs-slider__left' => 'max-width: {{SIZE}}{{UNIT}};flex-basis: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'width_content_right',
			array(
				'label'      => esc_html__( 'Width Right', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'      => array(
					'%'  => array(
						'min' => 0,
						'max' => 100,
					),
					'px' => [
						'min'  => 0,
						'max'  => 2000,
						'step' => 5,
					],
				),
				'selectors'  => array(
					'{{WRAPPER}} .thim-tabs-slider__right' => 'max-width: {{SIZE}}{{UNIT}};flex-basis: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'margin_right_content',
			array(
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					"{{WRAPPER}} .thim-tabs-slider__right" => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function _register_section_header_style() {
		$this->start_controls_section(
			'heading_style_section',
			array(
				'label' => esc_html__( 'Header', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->register_style_typo_color_margin( 'header_title', '.thim-tabs-slider__right__header__title' );

		$this->add_control(
			'heading_subtitle', [
				'label'     => esc_html__( 'Subtitle', 'coaching' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_style_typo_color_margin( 'header_subtitle', '.thim-tabs-slider__right__header__subtitle' );

		$this->end_controls_section();
	}

	protected function _register_section_item_style() {
		$this->start_controls_section(
			'item_style_section',
			array(
				'label' => esc_html__( 'Item', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'item_icon_size',
			array(
				'label'      => esc_html__( 'Icon Size', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 1,
						'max'  => 100,
						'step' => 2,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item svg' => 'max-width: {{SIZE}}{{UNIT}}; height: auto',
				),
			)
		);

		$this->add_responsive_control(
			'item_padding',
			array(
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					"{{WRAPPER}} .thim-tabs-slider__right__slide__item" => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs( 'item_style_tabs' );

		$this->start_controls_tab(
			'item_style_normal',
			array(
				'label' => esc_html__( 'Normal', 'coaching' ),
			)
		);

		$this->add_control(
			'item_opacity_normal',
			array(
				'label'     => esc_html__( 'Opacity', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 1,
						'step' => 0.1,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item' => 'opacity: {{SIZE}}',
				),
			)
		);

		$this->add_control(
			'item_color',
			array(
				'label'     => esc_html__( 'Item Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'item_border',
				'selector' => '{{WRAPPER}} .thim-tabs-slider__right__slide__item',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'item_style_active',
			array(
				'label' => esc_html__( 'Active', 'coaching' ),
			)
		);

		$this->add_control(
			'item_opacity_active',
			array(
				'label'     => esc_html__( 'Opacity', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'min'  => 0,
						'max'  => 1,
						'step' => 0.1
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item.slick-current' => 'opacity: {{SIZE}}',
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item:hover'         => 'opacity: {{SIZE}}',
				),
			)
		);

		$this->add_control(
			'item_color_active',
			array(
				'label'     => esc_html__( 'Item Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item.slick-current' => 'color: {{VALUE}}',
					'{{WRAPPER}} .thim-tabs-slider__right__slide__item:hover'         => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'item_border_active',
				'selector' => '{{WRAPPER}} .thim-tabs-slider__right__slide__item.slick-current, {{WRAPPER}} .thim-tabs-slider__right__slide__item:hover'
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_control(
			'heading_item_title', [
				'label'     => esc_html__( 'Title', 'coaching' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_style_typo_color_margin( 'item_title', '.thim-tabs-slider__right__slide__item-title' );

		$this->add_control(
			'heading_item_description', [
				'label'     => esc_html__( 'Description', 'coaching' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_style_typo_color_margin( 'item_description', '.thim-tabs-slider__right__slide__item-description' );

		$this->add_control(
			'heading_item_number', [
				'label'     => esc_html__( 'Number', 'coaching' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_style_typo_color_margin( 'item_number', '.thim-tabs-slider__right__slide__item-number' );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		?>
		<div class="thim-tabs-slider">
			<div class="thim-tabs-slider__left">
				<div id="thim-slick" class="thim-tabs-slider__left__slide"
					 data-autoplay="<?php if ( $settings['auto_play'] === 'yes' ) {
						 echo '1';
					 } else {
						 echo '';
					 } ?>">
					<?php
					if ( ! empty( $settings['item'] ) ) :
						foreach ( $settings['item'] as $item ) :
							$thumbnail_html = Group_Control_Image_Size::get_attachment_image_html( $item, 'item_image' );
							if ( ! empty( $thumbnail_html ) ) :
								echo '<div class="item">';
								echo wp_kses_post( $thumbnail_html );
								echo '</div>';
							endif;
						endforeach;
					endif;
					?>
				</div>
			</div>

			<div class="thim-tabs-slider__right">
				<?php
				if ( ! empty( $settings['title'] ) || ! empty( $settings['sub_heading'] ) ) :
					echo '<div class="thim-tabs-slider__right__header"> ';

					if ( ! empty( $settings['title'] ) ) :
						echo '<h2 class="thim-tabs-slider__right__header__title">' . wp_kses_post( $settings['title'] ) . '</h2>';
					endif;
					if ( ! empty( $settings['sub_heading'] ) ) :
						echo '<p class="thim-tabs-slider__right__header__subtitle">' . wp_kses_post( $settings['sub_heading'] ) . '</p>';
					endif;

					echo '</div>';
				endif; ?>
				<div id="thim-slick-vertical" class="thim-tabs-slider__right__slide"
					 data-autoplay="<?php if ( $settings['auto_play'] === 'yes' ) {
						 echo '1';
					 } else {
						 echo '';
					 } ?>">
					<?php
					if ( ! empty( $settings['item'] ) ) :
						foreach ( $settings['item'] as $key => $item ) : ?>
							<div class="thim-tabs-slider__right__slide__item">
								<?php if ( $settings['show_number_item'] === 'yes' ) :
									echo '<span class="thim-tabs-slider__right__slide__item-number">' . str_pad( ++ $key, 2, "0", STR_PAD_LEFT ) . '</span>';
								endif; ?>
								<div class="thim-tabs-slider__right__slide__item-content">
									<?php
									if ( $item['item_icon'] ) :
										Icons_Manager::render_icon( $item['item_icon'], array( 'class' => 'thim-tabs-slider__right__slide__item-icon' ) );
									endif;
									if ( ! empty( $item['item_title'] ) ) :
										echo '<h4 class="thim-tabs-slider__right__slide__item-title">' . wp_kses_post( $item['item_title'] ) . '</h4>';
									endif;
									if ( ! empty( $item['item_sub_heading'] ) ) :
										echo '<p class="thim-tabs-slider__right__slide__item-description">' . wp_kses_post( $item['item_sub_heading'] ) . '</p>';
									endif;
									?>
								</div>
							</div>
						<?php
						endforeach;
					endif; ?>
				</div>
			</div>
		</div>
		<?php
		$this->add_slide_js();
	}

	protected function add_slide_js() {
		?>
		<script type="text/javascript">
			jQuery(document).ready(function ($) {
				if (jQuery().slick) {
					let is_rtl = $('body').hasClass('rtl') ? true : false;
					let auto_play = false

					jQuery('#thim-slick').each(function () {
						if ($(this).data('autoplay') == '1') {
							auto_play = true;
						}
						$(this).slick({
							rtl           : is_rtl,
							slidesToShow  : 1,
							slidesToScroll: 1,
							arrows        : false,
							swipeToSlide  : false,
							focusOnSelect : false,
							draggable     : false,
							infinite      : true,
							autoplay      : auto_play,
							speed         : 1500,
							sync          : '#thim-slick-vertical'
						});
					});

					jQuery('#thim-slick-vertical').each(function () {
						if ($(this).data('autoplay') == '1') {
							auto_play = true;
						}
						$(this).slick({
							rtl            : is_rtl,
							vertical       : true,
							verticalSwiping: true,
							slidesToShow   : 3,
							slidesToScroll : 1,
							arrows         : false,
							swipeToSlide   : true,
							focusOnSelect  : true,
							infinite       : true,
							autoplay       : auto_play,
							speed          : 1500,
							asNavFor       : "#thim-slick",
							responsive     : [
								{
									breakpoint: 1500,
									settings  : {
										slidesToShow: 2,
									},
								},
								{
									breakpoint: 767,
									settings  : {
										slidesToShow: 3,
									},
								},
							],
						});
					});
				}
			});
		</script>
		<?php
	}
}
