<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Timeline_Slider_El extends Widget_Base {

	public function get_name() {
		return 'thim-timeline-slider';
	}

	public function get_title() {
		return esc_html__( 'Thim: Timeline Slider', 'coaching' );
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-timeline-slider';
	}
	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-timeline-slider';
	}

	public function get_categories() {
		return [ 'thim_coaching' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Add Timeline Slider', 'coaching' ),
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title for timeline.', 'coaching' ),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__( 'Description for timeline.', 'coaching' ),
                'type'        => Controls_Manager::TEXTAREA,
            ]
        );

        $repeater->add_control(
            'timeline',
            [
                'label' => esc_html__( 'Date time for timeline.', 'coaching' ),
                'type'    => Controls_Manager::TEXT,
            ]
        );


        $this->add_control(
            'item',
            [
                'label'       => esc_html__( 'Timelines', 'coaching' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'number',
            [
                'type'        => Controls_Manager::NUMBER,
                'default' => '4',
                'label'   => esc_html__( 'Visible Item', 'coaching' ),
            ]
        );

		$this->end_controls_section();
        $this->timeline_tabs_style_sc();
	}
    protected function timeline_tabs_style_sc(){
        $this->start_controls_section(
			'timel_line_style_section',
			array(
				'label'     => esc_html__( 'Style', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
        $this->add_control(
			'timel_line_hading_title',
			[
				'label' => esc_html__( ' Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'timel_line__title_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-timeline-slider .title' => 'color: {{VALUE}}  !important;',
					'{{WRAPPER}}  .thim-timeline-slider .title:after' => 'color: {{VALUE}}  !important;',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'timel_line_title_typography',
				'selector' => '{{WRAPPER}} .thim-timeline-slider .title',
			]
		);
		$this->add_responsive_control(
			'timel_line_space_between_title',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'label' => esc_html__( 'Spacing', 'coaching' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .thim-timeline-slider .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'timel_line__title_line_color',
			[
				'label'     => esc_html__( 'Color line', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-timeline-slider .title:after' => 'background-color: {{VALUE}}  !important;',
				],
			]
		);
        $this->add_control(
			'timel_line_hading_content',
			[
				'label' => esc_html__( ' Content', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'timel_line_content_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-timeline-slider .description' => 'color: {{VALUE}}  !important;',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'timel_line_content_typography',
				'selector' => '{{WRAPPER}} .thim-timeline-slider .description',
			]
		);
		$this->add_responsive_control(
			'timel_line_space_between_content',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'label' => esc_html__( 'Spacing', 'coaching' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .thim-timeline-slider .description' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'timel_line_hading_line',
			[
				'label' => esc_html__( ' Line', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'timel_line_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-timeline-slider .line' => 'background-color: {{VALUE}}  !important;',
				],
			]
		);
		$this->add_control(
			'timel_line_hading_box',
			[
				'label' => esc_html__( 'Box', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'timel_line_box_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-timeline-slider .item .top' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
  				],
			]
		);
		$this->add_control(
			'timel_line_box_color',
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-timeline-slider .item .top' => 'background-color: {{VALUE}}  !important;',
					'{{WRAPPER}} .thim-timeline-slider .item:after' => 'border-color: {{VALUE}}  transparent transparent transparent !important;',
				],
			]
		);
		$this->add_control(
			'timel_line_hading_dot',
			[
				'label' => esc_html__( 'Dot', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'timel_line_dot_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .bottom .dot' => 'background-color: {{VALUE}}  !important;',
				],
			]
		);
		$this->add_control(
			'timel_line_hading_time',
			[
				'label' => esc_html__( 'Time', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'timel_line_time_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .bottom .time' => 'color: {{VALUE}}  !important;',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'timel_line_time_typography',
				'selector' => '{{WRAPPER}} .bottom .time',
			]
		);
        $this->end_controls_section();
    }

	protected function render() {
		$settings = $this->get_settings_for_display();

         thim_get_widget_template( $this->get_base(), array(
            'instance' => $settings
        ) );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Timeline_Slider_El() );
