<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package thim
 */
?><!DOCTYPE html>

<html style="overflow: auto" itemscope
	  itemtype="http://schema.org/WebPage" <?php language_attributes(); ?><?php if ( get_theme_mod( 'thim_rtl_support', '0' ) == '1' || is_rtl() ) {
	echo " dir=\"rtl\"";
} ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php
	wp_head();
	?>
</head>
<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
	wp_body_open();
} ?>

<?php do_action( 'thim_before_body' ); ?>

<!-- menu for mobile-->
<div id="wrapper-container" class="wrapper-container">
	<div class="content-pusher">

		<header id="masthead" class="site-header affix-top<?php thim_header_class(); ?>">
			<?php
			//Toolbar
			if ( get_theme_mod( 'thim_toolbar_show', 1 ) == '1' && ( get_theme_mod( 'thim_header_style', 'header_v1' ) == 'header_v1' || get_theme_mod( 'thim_header_style', 'header_v1' ) == 'header_v4' ) ) {
				get_template_part( 'inc/header/toolbar' );
			}

			get_template_part( 'inc/header/' . get_theme_mod( 'thim_header_style', 'header_v1' ) );
			?>
		</header>
		<!-- Mobile Menu-->
		<nav class="mobile-menu-container mobile-effect">
			<?php get_template_part( 'inc/header/menu-mobile' ); ?>
		</nav>
		<div id="main-content">
