<?php
/**
 * Section Course Features
 *
 * @package Coaching
 */

thim_customizer()->add_section(
    array(
        'id'       => 'course_features',
        'panel'    => 'course',
        'title'    => esc_html__( 'Features', 'coaching' ),
        'priority' => 20,
    )
);

// Enable or Disable Login Popup when take this course
thim_customizer()->add_field(
    array(
        'id'          => 'thim_learnpress_single_popup',
        'type'        => 'switch',
        'label'       => esc_html__( 'Enable Login Popup', 'coaching' ),
        'tooltip'     => esc_html__( 'Enable login popup when take this course with user not logged in.', 'coaching' ),
        'section'     => 'course_features',
        'default'     => true,
        'priority'    => 15,
        'choices'     => array(
            true  	  => esc_html__( 'Show', 'coaching' ),
            false	  => esc_html__( 'Hide', 'coaching' ),
        ),
    )
);

// Enable or Disable Login Popup when take this course
thim_customizer()->add_field(
    array(
        'id'          => 'thim_learnpress_hidden_ads',
        'type'        => 'switch',
        'label'       => esc_html__( 'Hidden Ads', 'coaching' ),
        'tooltip'     => esc_html__( 'Hidden ads learnpress on WordPress admin.', 'coaching' ),
        'section'     => 'course_features',
        'default'     => true,
        'priority'    => 50,
        'choices'     => array(
            true  	  => esc_html__( 'Show', 'coaching' ),
            false	  => esc_html__( 'Hide', 'coaching' ),
        ),
    )
);

//// Enable or Disable Login Popup when take this course
if ( class_exists( '\Thim_EL_Kit\Functions' ) ) {
	$loop_course_item = array( '' => esc_html__( 'Default', 'thim-elementor-kit' ) ) + \Thim_EL_Kit\Functions::instance()->get_pages_loop_item( 'lp_course' );
} else {
	$loop_course_item = array( '' => esc_html__( 'Default', 'thim-elementor-kit' ) );
}

thim_customizer()->add_field(
	array(
		'id'          => 'loop_course_item',
		'type'        => 'select',
		'label'       => esc_html__( 'Loop Course Item', 'coaching' ),
		'section'     => 'course_features',
		'description' => sprintf( __( 'You can build loop course item in %s.', 'coaching' ), '<a href="' . admin_url( 'edit.php?post_type=thim_elementor_kit&thim_elementor_type=loop_item' ) . '" target="_blank">' . __( 'Thim Elementor Kit', 'coaching' ) . '</a>' ),
		'priority'    => 50,
		'choices'     => $loop_course_item,
		'default'     => '',
	)
);
