<?php
/**
 * Section Archive
 *
 * @package coaching
 */

thim_customizer()->add_section(
	array(
		'id'       => 'portfolio_archive',
		'panel'    => 'portfolio',
		'title'    => esc_html__( 'Archive Pages', 'coaching' ),
		'priority' => 10,
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_portfolio_cate_layout',
		'type'     => 'radio-image',
		'label'    => esc_html__( 'Archive Layouts', 'coaching' ),
		'tooltip'  => esc_html__( 'Allows you to choose a layout for all portfolio archive pages.', 'coaching' ),
		'section'  => 'portfolio_archive',
		'priority' => 12,
		'default'  => 'full-content',
		'choices'  => array(
			'sidebar-left'  => THIM_URI . 'images/layout/sidebar-left.jpg',
			'full-content'    => THIM_URI . 'images/layout/body-full.jpg',
			'sidebar-right' => THIM_URI . 'images/layout/sidebar-right.jpg',
		),
		'wrapper_attrs' => array(
			'class' => '{default_class} thim-col-3'
		)
	)
);

// Enable or disable breadcrumbs
thim_customizer()->add_field(
	array(
		'id'       => 'thim_portfolio_cate_hide_breadcrumbs',
		'type'     => 'switch',
		'label'    => esc_html__( 'Hide Breadcrumbs?', 'coaching' ),
		'tooltip'  => esc_html__( 'Check this box to hide/show breadcrumbs.', 'coaching' ),
		'section'  => 'portfolio_archive',
		'default'  => false,
		'priority' => 15,
		'choices'  => array(
			true  => esc_html__( 'On', 'coaching' ),
			false => esc_html__( 'Off', 'coaching' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'thim_top_site_main_layout',
				'operator' => '!=',
				'value'    => 'elementor',
			),
		),
	)
);

// Enable or disable title
thim_customizer()->add_field(
	array(
		'id'       => 'thim_portfolio_cate_hide_title',
		'type'     => 'switch',
		'label'    => esc_html__( 'Hide Title', 'coaching' ),
		'tooltip'  => esc_html__( 'Check this box to hide/show title.', 'coaching' ),
		'section'  => 'portfolio_archive',
		'default'  => false,
		'priority' => 18,
		'choices'  => array(
			true  => esc_html__( 'On', 'coaching' ),
			false => esc_html__( 'Off', 'coaching' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'thim_top_site_main_layout',
				'operator' => '!=',
				'value'    => 'elementor',
			),
		),
	)
);

thim_customizer()->add_field(
	array(
		'type'     => 'text',
		'id'       => 'thim_portfolio_cate_sub_title',
		'label'    => esc_html__( 'Sub Heading', 'coaching' ),
		'tooltip'  => esc_html__( 'Allows you can setup sub heading.', 'coaching' ),
		'section'  => 'portfolio_archive',
		'priority' => 20,
		'active_callback' => array(
			array(
				'setting'  => 'thim_top_site_main_layout',
				'operator' => '!=',
				'value'    => 'elementor',
			),
		),
	)
);

thim_customizer()->add_field(
	array(
		'type'      => 'image',
		'id'        => 'thim_portfolio_cate_top_image',
		'label'     => esc_html__( 'Top Image', 'coaching' ),
		'priority'  => 30,
		'transport' => 'postMessage',
		'section'  => 'portfolio_archive',
		'default'     => THIM_URI . "images/bg-page.jpg",
		'active_callback' => array(
			array(
				'setting'  => 'thim_top_site_main_layout',
				'operator' => '!=',
				'value'    => 'elementor',
			),
		),
	)
);

// Page Title Background Color
thim_customizer()->add_field(
	array(
		'id'          => 'thim_portfolio_cate_bg_color',
		'type'        => 'color',
		'label'       => esc_html__( 'Background Color', 'coaching' ),
		'tooltip'     => esc_html__( 'If you do not use background image, then can use background color for page title on heading top. ', 'coaching' ),
		'section'     => 'portfolio_archive',
		'default'     => 'rgba(0,0,0,0.5)',
		'priority'    => 35,
		'alpha'       => true,
		'transport' => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'thim_top_site_main_layout',
				'operator' => '!=',
				'value'    => 'elementor',
			),
		),
		'js_vars'   => array(
			array(
				'choice'   => 'color',
				'element'  => '.top_site_main>.overlay-top-header',
				'property' => 'background',
			)
		)
	)
);

thim_customizer()->add_field(
	array(
		'id'          => 'thim_portfolio_cate_title_color',
		'type'        => 'color',
		'label'       => esc_html__( 'Title Color', 'coaching' ),
		'tooltip'     => esc_html__( 'Allows you can select a color make text color for title.', 'coaching' ),
		'section'     => 'portfolio_archive',
		'default'     => '#ffffff',
		'priority'    => 40,
		'alpha'       => true,
		'transport' => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'thim_top_site_main_layout',
				'operator' => '!=',
				'value'    => 'elementor',
			),
		),
		'js_vars'   => array(
			array(
				'choice'   => 'color',
				'element'  => '.top_site_main h1, .top_site_main h2',
				'property' => 'color',
			)
		)
	)
);

thim_customizer()->add_field(
	array(
		'id'          => 'thim_portfolio_cate_sub_title_color',
		'type'        => 'color',
		'label'       => esc_html__( 'Sub Title Color', 'coaching' ),
		'tooltip'     => esc_html__( 'Allows you can select a color make sub title color page title.', 'coaching' ),
		'section'     => 'portfolio_archive',
		'default'     => '#999',
		'priority'    => 45,
		'alpha'       => true,
		'transport' => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'thim_top_site_main_layout',
				'operator' => '!=',
				'value'    => 'elementor',
			),
		),
		'js_vars'   => array(
			array(
				'choice'   => 'color',
				'element'  => '.top_site_main .banner-description',
				'property' => 'color',
			)
		)
	)
);

thim_customizer()->add_field(
	array(
		'type'     => 'select',
		'id'       => 'thim_portfolio_cate_style_chosen',
		'label'    => esc_html__( 'Hover Effect Style', 'coaching' ),
		'tooltip'  => esc_html__( 'Allows select hover effect style which you want to using.', 'coaching' ),
		'priority' => 55,
		'multiple' => 0,
		'default'  => 'style01',
		'section'  => 'portfolio_archive',
		'choices'  => array(
			'style01' => esc_html__( 'Caption Hover Effects 01', 'coaching' ),
			'style02' => esc_html__( 'Caption Hover Effects 02', 'coaching' ),
			'style03' => esc_html__( 'Caption Hover Effects 03', 'coaching' ),
			'style04' => esc_html__( 'Caption Hover Effects 04', 'coaching' ),
			'style05' => esc_html__( 'Caption Hover Effects 05', 'coaching' ),
			'style06' => esc_html__( 'Caption Hover Effects 06', 'coaching' ),
			'style07' => esc_html__( 'Caption Hover Effects 07', 'coaching' ),
			'style08' => esc_html__( 'Caption Hover Effects 08', 'coaching' ),
			'style09' => esc_html__( 'Caption Hover Effects 09', 'coaching' ),
			'style10' => esc_html__( 'Caption Hover Effects 10', 'coaching' ),
			'style11' => esc_html__( 'Caption Hover Effects 11', 'coaching' )
		),
	)
);