<?php

/**
 * Class Thim_LP_Filter_Layout
 *
 * @since   from LP v4.2.5.6
 * @version 1.0.0
 */

use LearnPress\TemplateHooks\Course\ListCoursesTemplate;
use LearnPress\Helpers\Template;
use LearnPress\Models\CourseModel;
use LearnPress\TemplateHooks\Course\SingleCourseTemplate;
use LearnPress\TemplateHooks\Course\SingleCourseOfflineTemplate;

class Thim_LP_Layout {

	public function __construct() {
		add_filter( 'learn-press/layout/list-courses/section/top', array( $this, 'course_layout_archive_section_top' ), 10, 3 );

		add_filter( 'learn-press/layout/list-courses/section', array( $this, 'layout_list_courses_section' ), 10, 3 );
		// Content item
		add_filter( 'learn-press/layout/list-courses/item/section-top', array( $this, 'course_item_section_top' ), 10, 3 );
		add_filter( 'learn-press/layout/list-courses/item/section/bottom', array( $this, 'course_item_section_bottom' ), 15, 3 );
		// Layout collection
		add_filter( 'learn-press/layout/list-collections/section', array( $this, 'lp_list_collection_layout' ), 10, 3 );

		add_filter( 'learn-press/single-collection/layout/section', function ( $sections ) {
			$sections['wrap'] = '<div class="lp-single-collection">' . $this->top_heading_collection();

			return $sections;
		}, 10, 2 );

		//layuot single collection learning
		add_filter( 'learn-press/single-collection-learning/layout/section', function ( $sections ) {
			$sections['container'] = '<div class="lp-collection-learning">' . $this->top_heading_collection();

			return $sections;
		}, 10, 2 );
	}

	public function course_layout_archive_section_top( $sections, $course, $settings ) {
		$listCoursesTemplate = ListCoursesTemplate::instance();
		$section             = array(
			'wrapper'                   => '<div class="lp-courses-bar thim-course-top switch-layout-container">',
			'switch_layout'             => $this->html_switch_layout(),
			'courses_result'            => sprintf( '<div class="course-index">%s</div>', $listCoursesTemplate->html_courses_page_result( $settings ) ),
			'btn_filter_courses_mobile' => $sections['btn_filter_courses_mobile'],
			'search'                    => sprintf( '<div class="courses-searching">%s</div>', $sections['search'] ),
			'wrapper_end'               => '</div>',
		);

		return $section;
	}

	public function html_switch_layout() {
		$layouts = learn_press_courses_layouts();
		$active  = learn_press_get_courses_layout();

		$html_layouts = '';
		foreach ( $layouts as $layout => $value ) {
			if ( $layout == 'grid' ) {
				$icon = 'fa-th-large';
			} else {
				$icon = 'fa-list-ul';
			}
			$html_layouts .= sprintf(
				'<input type="radio" name="lp-switch-layout-btn" value="%s" id="lp-switch-layout-btn-%s" %s>
				<label class="lp-switch-btn %s" title="%s" for="lp-switch-layout-btn-%s"><i class="fa ' . '%s' . '"></i></label>',
				esc_attr( $layout ),
				esc_attr( $layout ),
				checked( $layout, $active, false ),
				esc_attr( $layout ),
				sprintf( esc_attr__( 'Switch to %s', 'learnpress' ), $value ),
				esc_attr( $layout ),
				esc_attr( $icon )
			);
		}
		$section = apply_filters(
			'learn-press/layout/list-courses/section/switch-layout',
			[
				'wrapper'     => '<div class="thim-course-switch-layout switch-layout">',
				'layouts'     => $html_layouts,
				'wrapper_end' => '</div>',
			]
		);

		return Template::combine_components( $section );
	}

	public function layout_list_courses_section( $sections, $courses, $settings ) {
		$cookie_name = 'courses-layout';
		$skin        = $settings['skin'] ?? ( wp_is_mobile() ? 'grid' : learn_press_get_courses_layout() );
		if ( ! empty( $_COOKIE[ $cookie_name ] ) ) {
			$skin = $_COOKIE[ $cookie_name ];
		}
		// HTML section courses.
		$html_courses = '';
		if ( empty( $courses ) ) {
			$html_courses = Template::print_message( __( 'No courses found', 'learnpress' ), 'info', false );
		} else {
			global $post;
			foreach ( $courses as $courseObj ) {
				$course = CourseModel::find( $courseObj->ID, true );
				if ( ! $course ) {
					continue;
				}
				$post = get_post( $course->get_id() );
				setup_postdata( $post );
				ob_start();
				learn_press_get_template_part( 'content', 'course' );
				$html_courses .= ob_get_clean();
			}
			wp_reset_postdata();
		}

		$section_courses = [
			'wrapper'     => sprintf( '<div id="thim-course-archive" class="thim-course-%1$s"><ul class="learn-press-courses lp-list-courses-no-css %1$s" data-layout="%1$s">', $skin ),
			'courses'     => $html_courses,
			'wrapper_end' => '</ul></div>',
		];

		$sections['courses'] = Template::combine_components( $section_courses );

		return $sections;
	}

	public function course_item_section_top( $sections, $course, $settings ) {
		$singleCourseTemplate = SingleCourseTemplate::instance();
		$section['wrapper']   = $sections['wrapper'];

		$section['img'] = sprintf( '<a href="%s" class="thumb">%s</a>', $course->get_permalink(), $singleCourseTemplate->html_image( $course ) );

		ob_start();
		if ( class_exists( 'LP_Addon_Wishlist' ) ) {
			LP_Addon_Wishlist_Preload::$addon->wishlist_button( $course->get_id() );
		}
		$wishlist_html       = ob_get_clean();
		$section['wishlist'] = $wishlist_html;

		$section['read_more'] = '<a class="course-readmore" href="' . esc_url( get_the_permalink( $course->get_id() ) ) . '" >' . esc_html__( 'Read More', 'coaching' ) . '</a>';

		if ( class_exists( 'LP_WC_Hooks' ) && method_exists( 'LP_WC_Hooks', 'button_add_to_cart' ) ) {
			$section_btn = LP_WC_Hooks::instance()->button_add_to_cart( $section, $course, '' );
			if ( isset( $section_btn['button_add_to_cart'] ) && ! empty( $section_btn['button_add_to_cart'] ) ) {
				$section['read_more'] = $section_btn['button_add_to_cart'];
			}
		}


		$section['wrapper_end'] = $sections['wrapper_end'];

		return $section;
	}

	public function course_item_section_bottom( $sections, $course, $settings ) {
		$html_meta_data        = '';
		$message               = '';
		$thim_show_course_meta = true;
		if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
			$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
			if ( $instance_addon->is_coming_soon( get_the_ID() ) ) {
				$thim_show_course_meta = false;
				$message               = get_post_meta( get_the_ID(), '_lp_coming_soon_msg', true );
			}
		}
		if ( $thim_show_course_meta ) {
			ob_start();
			?>
			<div class="course-description">
				<?php
				echo wpautop( get_the_excerpt( $course->get_id() ) );
				?>
			</div>

			<div class="course-meta">

				<?php
				echo SingleCourseTemplate::instance()->html_instructor( $course, true );
				if ( class_exists( 'LP_Addon_Course_Review' ) ) {

					$course_rate = learn_press_get_course_rate( $course->get_id(), false );
					echo LP_Addon_Course_Review_Preload::$addon->get_template( 'rating-stars.php', array( 'rated' => $course_rate["rated"] ) );
				} ?>
				<?php echo sprintf(
					'<div class="course-student">
							<div class="value"><i class="lp-icon-students"></i> %s</div>
						</div>',
					$course->count_students()
				); ?>
				<?php echo SingleCourseTemplate::instance()->html_price( $course ); ?>
			</div>

			<?php
			$html_meta_data = ob_get_clean();
		} else {
			$html_meta_data = '<div class="message message-warning coming-soon-message">' . $message . '</div>';
		}
		// HTML bottom section end.
		$section_bottom_end = apply_filters(
			'learn-press/layout/list-courses/item/section/bottom/end',
			[
				'wrapper'       => '<div class="course-info">',
				'btn_read_more' => sprintf(
					'<div class="course-readmore"><a href="%s">%s</a></div>',
					$course->get_permalink(),
					__( 'Read more', 'learnpress' )
				),
				'wrapper_end'   => '</div>',
			],
			$course,
			$settings
		);
		$section            = [
			'wrapper'     => '<div class="thim-course-content">',
			'title'       => sprintf(
				'<h2 class="course-title"><a class="course-permalink" href="%s">%s</a></h2>',
				$course->get_permalink(),
				$course->get_title()
			),
			'meta_data'   => $html_meta_data,
			'info'        => Template::combine_components( $section_bottom_end ),
			'wrapper_end' => '</div>',
		];

		return $section;
	}

	public function lp_list_collection_layout( $sections ) {
		ob_start();
		do_action( 'thim_wrapper_loop_start' );
		$sections['container'] = ob_get_clean();
		unset( $sections['title'] );
		ob_start();
		do_action( 'thim_wrapper_loop_end' );
		$sections['container_end'] = ob_get_clean();

		return $sections;
	}

	public function top_heading_collection() {
		$html_top_heading = '';
		if ( get_theme_mod( 'thim_header_position', 'header_overlay' ) == 'header_overlay' ) {
			$cate_top_image = get_theme_mod( 'thim_collection_single_top_image' );
			if ( is_numeric( $cate_top_image ) ) {
				$cate_top_attachment = wp_get_attachment_image_src( $cate_top_image, 'full' );
				$cate_top_image_src  = $cate_top_attachment[0];
			} else {
				$cate_top_image_src = $cate_top_image;
			}
			$style_bg    = $cate_top_image_src ? ' style=" background-image:url(' . $cate_top_image_src . ')"' : '';
			$bg_color    = get_theme_mod( 'thim_collection_single_bg_color' );
			$style_color = $bg_color ? ' style=" background-color:' . $bg_color . '"' : '';

			$html_top_heading = '<div class="top_heading_out">';
			$html_top_heading .= '<div class="top_site_main"' . $style_bg . '>
					<span class="overlay-top-header"' . $style_color . '></span>
			</div>';
			$html_top_heading .= '</div>';
		}

		return $html_top_heading;
	}
}

new Thim_LP_Layout();
