<?php
$plugin_required_all_demo = array(
	'learnpress',
	'learnpress-course-review',
	'learnpress-wishlist',
	'mailchimp-for-wp',
	'contact-form-7',
	'woocommerce',
	'revslider',
	'wp-events-manager',
	'tp-portfolio',
	'thim-testimonials',
	'pricing-table-plus',
	'thim-our-team',
);
$demos_el                 = [];
$link_image               = 'https://thimpresswp.github.io/demo-data/';
if ( apply_filters( 'thim-importer-demo-vc', false ) || get_theme_mod( 'thim_page_builder_chosen' ) == 'visual_composer' ) {
	$folder_demo                  = 'demo-vc';
	$plugin_required_page_builder = array( 'js_composer' );
} elseif ( apply_filters( 'thim-importer-demo-so', false ) || get_theme_mod( 'thim_page_builder_chosen' ) == 'site_origin' ) {
	// support importer with
	$folder_demo                  = 'demo-so';
	$plugin_required_page_builder = array( 'siteorigin-panels', 'classic-editor' );
} else {
	$folder_demo                  = 'demo-el';
	$plugin_required_page_builder = array( 'elementor', 'thim-elementor-kit' );
	$demos_el                     = array(
		'demo-el/life-coaching'          => array(
			'title'            => esc_html__( 'Life Coaching', 'coaching' ),
			'demo_url'         => 'https://coaching.thimpress.com/life-coaching/',
			'thumbnail_url'    => $link_image . 'coaching/images/life-coaching.jpg',
			'plugins_required' => array_merge(
				$plugin_required_all_demo,
				$plugin_required_page_builder,
				[ 'instagram-feed' ]
			),
		),
		'demo-el/business-consulting'    => array(
			'title'            => esc_html__( 'Business Consulting', 'coaching' ),
			'demo_url'         => 'https://coaching.thimpress.com/business-consulting/',
			'thumbnail_url'    => $link_image . 'coaching/images/business-consulting.jpg',
			'plugins_required' => array_merge(
				$plugin_required_all_demo,
				$plugin_required_page_builder
			),
		),
		'demo-el/business-coaching-2'    => array(
			'title'            => esc_html__( 'Demo Business Coaching 2', 'coaching' ),
			'demo_url'         => 'https://coaching.thimpress.com/business-coaching-2/',
			'thumbnail_url'    => $link_image . 'coaching/images/business-coaching-2.jpg',
			'plugins_required' => array_merge(
				$plugin_required_all_demo,
				$plugin_required_page_builder,
				[ 'woo-booster-toolkit' ]
			),
		),
		'demo-el/demo-business-coaching' => array(
			'title'            => esc_html__( 'Demo Business Coaching', 'coaching' ),
			'demo_url'         => 'https://coaching.thimpress.com/business-coaching/',
			'thumbnail_url'    => $link_image . 'coaching/images/demo-business-2.jpg',
			'plugins_required' => array_merge(
				$plugin_required_all_demo,
				$plugin_required_page_builder
			),
		),
		'demo-el/demo-healthy-coaching'  => array(
			'title'            => esc_html__( 'Demo Healthy Coaching', 'coaching' ),
			'demo_url'         => 'http://coaching.thimpress.com/healthy-coaching/',
			'thumbnail_url'    => $link_image . 'coaching/images/demo-healthy-coaching.jpg',
			'plugins_required' => array_merge(
				$plugin_required_all_demo,
				$plugin_required_page_builder
			),
		),
	);
}

$all_plugin = array_merge( $plugin_required_all_demo, $plugin_required_page_builder );

$demo_data = array(
	"$folder_demo/demo-01"        => array(
		'title'            => esc_html__( 'Demo Life Coaching', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2017/08/coaching-01.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'home-01.zip',
		),
	),

	"$folder_demo/demo-02"        => array(
		'title'            => esc_html__( 'Demo Health Coaching 1', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-health-coaching/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2017/08/coaching-02.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'home-02.zip',
		),
	),
	"$folder_demo/demo-03"        => array(
		'title'            => esc_html__( 'Demo Health Coaching 2', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-health-coaching-2/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2017/08/coaching-03.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'home-03.zip',
		),
	),
	"$folder_demo/demo-04"        => array(
		'title'            => esc_html__( 'Demo Health Coaching 3', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-health-coaching-3/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2017/08/coaching-04.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'home-04.zip',
		),
	),
	"$folder_demo/demo-effective" => array(
		'title'            => esc_html__( 'Demo Effective', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-effective-coaching/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2018/07/coaching-effective-2.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'demo-effective.zip',
		),
	),
	"$folder_demo/demo-05"        => array(
		'title'            => esc_html__( 'Demo Instructor', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-instructor/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2019/10/coaching-home-instructor.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'home-5-slider.zip',
		),
	),
	"$folder_demo/demo-therapist" => array(
		'title'            => esc_html__( 'Demo Therapist', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-therapist/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2019/05/coaching-therapist.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'demo-therapist.zip',
		),
	),
	"$folder_demo/demo-business"  => array(
		'title'            => esc_html__( 'Demo Business', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-bussiness/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2017/08/demo_bussiness.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'demo-bussiness.zip',
		),
	),
	"$folder_demo/demo-gym"       => array(
		'title'            => esc_html__( 'Demo Gym', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-gym-coaching/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2019/05/coaching-gym.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'demo-gym.zip',
		),
	),
	"$folder_demo/demo-rtl"       => array(
		'title'            => esc_html__( 'Demo RTL', 'coaching' ),
		'demo_url'         => 'https://coaching.thimpress.com/demo-rtl/',
		'thumbnail_url'    => 'https://updates.thimpress.com/wp-content/uploads/2018/06/coaching-rtl.jpg',
		'plugins_required' => array_merge(
			$plugin_required_all_demo,
			$plugin_required_page_builder
		),
		'revsliders'       => array(
			'home-rtl.zip',
		),
	),
);

$demo_datas = array_merge(
	$demos_el,
	$demo_data
);

return $demo_datas;
