<?php
namespace Thim_EL_Kit\Elementor\DynamicTags\Tags;

use Elementor\Controls_Manager;
use \Elementor\Core\DynamicTags\Tag as Tag_Base;
use Elementor\Modules\DynamicTags\Module as TagsModule;
use Elementor\Group_Control_Image_Size;

defined( 'ABSPATH' ) || exit;

class Title_Tab extends Tag_Base {

	public function get_name() {
		return 'thim-item-title-tab';
	}

	public function get_categories() {
		return array( TagsModule::TEXT_CATEGORY );
	}

	public function get_group() {
		return array( 'thim-ekit' );
	}

	public function get_title() {
		return 'Item Title Tab';
	}

    protected function register_controls() {
		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
                'placeholder' => 'title',
                'default'     => esc_html__( 'Title', 'coaching' )
			]
		);
        $this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'coaching' ),
				'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => 'description',
                'default'     => esc_html__( 'description', 'coaching' )
			]
		);
        $this->add_control(
			'number',
			[
				'label'       => esc_html__( 'Number', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
                'placeholder' => 'number',
                'default'     => esc_html__( '01', 'coaching' )
			]
		);
        $this->add_control(
			'image',
			array(
				'label' => esc_html__( 'Image', 'thim-elementor-kit' ),
				'type'  => Controls_Manager::MEDIA,
			)
		);
	}

	public function render() {
        $settings = $this->get_settings();
        $html_img = Group_Control_Image_Size::get_attachment_image_html( $settings, 'image' );
        $class = '';

        if ( $html_img != $class ){
            $class = 'image-show';
        }

        $this->add_render_attribute(
            'thim_dynamic_title_tab',
            array(
                'class' => 'dynamic-title-tab '.$class.'',
                'style' => "--dynamic-background-image: url(" . esc_url( $settings['image']['url'] ) . ")",
            )
        );
       
        ?>
        <div <?php $this->print_render_attribute_string( 'thim_dynamic_title_tab' ) ?>>
			<?php 
			if( $settings['number'] != '' ) : 
            	echo '<span class="dynamic-title-tab__number-step">'. $settings['number'] .'</span>';
			endif;
			if ( !empty( $settings['title'] ) || !empty( $settings['description'] ) ) :
				echo '<div class="dynamic-title-tab__content">';
					if ( !empty( $settings['title'] ) ) :
						echo '<h5 class="dynamic-title-tab__heading">'. wp_kses_post( $settings['title'] ) .'</h5>';
					endif;
					if ( !empty( $settings['description'] ) ) :
						echo '<p class="dynamic-title-tab__subtitle">'. wp_kses_post( $settings['description'] ) .'</p>';
					endif;
				echo '</div>'; 
			endif; ?>
        </div>
        <?php
	}
}
