<?php

/**
 * Custom functions for LearnPress
 *
 * @package thim
 */

use LearnPress\Helpers\Template;
use Thim_EL_Kit\Functions;

add_filter( 'learn-press/override-templates', '__return_true' );
add_filter( 'lp/template-course/course_curriculum/skeleton', '__return_true' );

if ( ! function_exists( 'thim_remove_learnpress_hooks' ) ) {
	function thim_remove_learnpress_hooks() {

		add_action( 'thim_single_course_payment', LearnPress::instance()->template( 'course' )->func( 'course_pricing' ), 5 );
		add_action( 'thim_single_course_payment', LearnPress::instance()->template( 'course' )->func( 'course_buttons' ), 10 );

		if ( class_exists( 'LP_WC_Hooks' ) && thim_is_version_addons_woo_payment( '4.0.3' ) ) {
			$lp_woo_hoocks    = LP_WC_Hooks::instance();
			$buy_with_product = get_option( 'learn_press_woo-payment_buy_course_via_product' );
			if ( $buy_with_product == 'yes' ) {
				add_action( 'thim-lp-course-button-read-more', 'thim_button_read_more_course' );
			} else {
				add_action( 'thim-lp-course-button-read-more', array( $lp_woo_hoocks, 'btn_add_to_cart' ) );
				// add button remove for course free
				add_action( 'learnpress/woo-payment/course-free/btn_add_to_cart_before', 'thim_button_read_more_course' );
			}
		} else {
			add_action( 'thim-lp-course-button-read-more', 'thim_button_read_more_course' );
		}

		LearnPress::instance()->template( 'course' )->remove( 'learn-press/single-button-toggle-sidebar', array( '<input type="checkbox" id="sidebar-toggle" />', 'single-button-toggle-sidebar' ), 5 );
		add_action( 'thim_single_course_meta', LearnPress::instance()->template( 'course' )->callback( 'single-course/instructor' ), 5 );
		add_action( 'thim_single_course_meta', LearnPress::instance()->template( 'course' )->callback( 'single-course/meta/category' ), 15 );
		add_action( 'thim_single_course_meta', 'thim_course_forum_link', 20 );
		add_action( 'thim_single_course_meta', 'thim_course_ratings', 25 );
		add_action( 'thim_single_course_meta', LearnPress::instance()->template( 'course' )->func( 'user_progress' ), 30 );
		add_action( 'thim_single_course_meta_cms_price', LearnPress::instance()->template( 'course' )->func( 'course_pricing' ), 5 );

		add_action(
			'init',
			function () {
				if ( class_exists( 'LP_Addon_Wishlist' ) && is_user_logged_in() && thim_is_version_addons_wishlist( '3' ) ) {
					$instance_addon = LP_Addon_Wishlist::instance();
					remove_action( 'learn-press/after-course-buttons', array( $instance_addon, 'wishlist_button' ), 100 );
					add_action( 'thim_inner_thumbnail_course', array( $instance_addon, 'wishlist_button' ), 10 );
				}
				if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
					$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
					remove_action( 'learn-press/course-content-summary', array( $instance_addon, 'coming_soon_countdown' ), 10 );
					add_action( 'learn-press/single-course-summary', array( $instance_addon, 'coming_soon_countdown' ), 5 );
				}
			},
			99
		);

		/**
		 *   Profile
		 */
		remove_action( 'learn-press/after-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'account_logged_in' ), 20 );
		remove_action( 'learn-press/after-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'order_comment' ), 60 );
		add_action( 'learn-press/before-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'account_logged_in' ), 9 );
		add_action( 'learn-press/before-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'order_comment' ), 11 );
		remove_action( 'learn-press/profile/dashboard-summary', LearnPress::instance()->template( 'profile' )->func( 'dashboard_featured_courses' ), 20 );
		/*
		 * Page check out
		 */
		add_action( 'learnpress/template/pages/profile/before-content', 'thim_wapper_page_title', 5 );
		add_action( 'learnpress/template/pages/profile/before-content', 'thim_wrapper_loop_start', 10 );
		add_action( 'learnpress/template/pages/profile/after-content', 'thim_wrapper_loop_end', 10 );

		add_action( 'learnpress/template/pages/checkout/before-content', 'thim_wapper_page_title', 5 );
		add_action( 'learnpress/template/pages/checkout/before-content', 'thim_wrapper_loop_start', 10 );
		add_action( 'learnpress/template/pages/checkout/after-content', 'thim_wrapper_loop_end', 10 );

		/**
		 * @see LP_Template_Course::popup_footer_nav()
		 */
		// remove html in begin loop and end loop
		add_filter( 'learn_press_course_loop_begin', function () {
			return '';
		} );
		add_filter(
			'learn_press_course_loop_end',
			function () {
				return '';
			}
		);
		remove_action( 'learn-press/user-item-progress', 'lp_assignments_add_item_user_progress', 10, 3 );
		remove_action( 'learn-press/user-profile-account', LearnPress::instance()->template( 'profile' )->func( 'socials' ), 10 );
		// remove option select single course layout
		add_filter( 'learn-press/course-settings-fields/general', function ( $fields ) {
			foreach ( $fields as $key => $field ) {
				if ( isset( $field['id'] ) && $field['id'] === 'layout_single_course' ) {
					unset( $fields[ $key ] );
				}
			}

			return $fields;
		} );
	}
}
add_action( 'after_setup_theme', 'thim_remove_learnpress_hooks', 15 );
// add div for thumb image when us coming soon
function thim_class_before_thumb_image() {
	$course = learn_press_get_course();
	if ( ! $course ) {
		echo '<div>';
	}
	$no_thumbnail = ' no-thumbnail';
	if ( has_post_thumbnail() ) {
		$no_thumbnail = '';
	}
	if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
		$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
		if ( $instance_addon->is_coming_soon( $course->get_id() ) ) {
			echo '<div class="thim-top-course' . $no_thumbnail . '">';
		} else {
			echo '<div>';
		}
	} else {
		echo '<div>';
	}
}

function thim_class_after_thumb_image() {
	echo '</div>';
}

add_filter( 'lp_item_course_class', 'thim_item_course_class_custom' );
function thim_item_course_class_custom( $class ) {
	$class[] = 'thim-course-grid';

	return $class;
}

add_action( 'learn-press/single-course-summary', 'thim_class_before_thumb_image', 1 );
add_action( 'learn-press/single-course-summary', 'thim_class_after_thumb_image', 6 );

/**
 * Remove Archive Course
 */
remove_action( 'learn-press/before-courses-loop', LearnPress::instance()->template( 'course' )->func( 'courses_top_bar' ) );
remove_action( 'learn-press/before-main-content', LearnPress::instance()->template( 'general' )->func( 'breadcrumb' ) );
/**
 * Remove Single Course
 */
remove_all_actions( 'learn-press/course-content-summary', 10 );
remove_all_actions( 'learn-press/course-content-summary', 15 );
remove_all_actions( 'learn-press/course-content-summary', 85 );


add_action( 'widget-grid-middle-content', LearnPress::instance()->template( 'course' )->callback( 'single-course/instructor' ), 5 );
add_action( 'widget-grid-middle-content', LearnPress::instance()->template( 'course' )->callback( 'loop/course/students' ), 10 );

function coaching_add_video_lesson() {
	lp_meta_box_textarea_field(
		array(
			'id'      => '_lp_lesson_video_intro',
			'label'   => esc_html__( 'Media intro', 'learnpress' ),
			'default' => '',
		)
	);
}

add_action( 'learnpress/lesson-settings/after', 'coaching_add_video_lesson' );

add_action(
	'learnpress_save_lp_lesson_metabox',
	function ( $post_id ) {
		$video = ! empty( $_POST['_lp_lesson_video_intro'] ) ? $_POST['_lp_lesson_video_intro'] : '';

		update_post_meta( $post_id, '_lp_lesson_video_intro', $video );
	}
);

// add cusom field for course
function coaching_add_custom_field_course() {
	lp_meta_box_text_input_field(
		array(
			'id'          => 'thim_course_duration',
			'label'       => esc_html__( 'Duration Info', 'coaching' ),
			'description' => esc_html__( 'Display duration info', 'coaching' ),
			'default'     => esc_html__( '50 hours', 'coaching' )
		)
	);
	lp_meta_box_text_input_field(
		array(
			'id'          => 'thim_course_language',
			'label'       => esc_html__( 'Languages', 'coaching' ),
			'description' => esc_html__( 'Language\'s used for studying', 'coaching' ),
			'default'     => esc_html__( 'English', 'coaching' )
		)
	);

	lp_meta_box_textarea_field(
		array(
			'id'          => 'thim_course_media_intro',
			'label'       => esc_html__( 'Media Intro', 'coaching' ),
			'description' => esc_html__( 'Enter media intro', 'coaching' ),
			'default'     => '',
		)
	);
}

add_action( 'learnpress/course-settings/after-general', 'coaching_add_custom_field_course' );

add_action(
	'learnpress_save_lp_course_metabox',
	function ( $post_id ) {
		$video         = ! empty( $_POST['thim_course_media_intro'] ) ? $_POST['thim_course_media_intro'] : '';
		$language      = ! empty( $_POST['thim_course_language'] ) ? $_POST['thim_course_language'] : '';
		$duration_info = ! empty( $_POST['thim_course_duration'] ) ? $_POST['thim_course_duration'] : '';

		update_post_meta( $post_id, 'thim_course_media_intro', $video );
		update_post_meta( $post_id, 'thim_course_language', $language );
		update_post_meta( $post_id, 'thim_course_duration', $duration_info );
	}
);

/**
 * @param Remaining time
 */
function thim_get_remaining_time() {

	$user   = LP_Global::user();
	$course = learn_press_get_course();

	if ( ! $course ) {
		return false;
	}

	if ( ! $user ) {
		return false;
	}

	if ( ! $user->has_enrolled_course( $course->get_id() ) ) {
		return false;
	}

	if ( $user->has_finished_course( $course->get_id() ) ) {
		return false;
	}

	$remaining_time = thim_timestamp_remaining_duration( $course );

	if ( false === $remaining_time ) {
		return false;
	}

	$time = '';
	$time .= '<div class="course-remaining-time message message-warning learn-press-message">';
	$time .= '<p>';
	$time .= sprintf( __( 'You have %s remaining for the course', 'coaching' ), $remaining_time );
	$time .= '</p>';
	$time .= '</div>';
	echo $time;
}

add_action( 'learn-press-course-curriculum', 'thim_get_remaining_time', 5 );

/**
 * custom remaning by UTC
 *
 * @param Remaining time
 */
function thim_timestamp_remaining_duration( LP_Course $course ) {

	$timestamp_remaining = - 1;
	$user                = learn_press_get_user( get_current_user_id() );

	if ( 0 === absint( $course->get_data( 'duration' ) ) ) {
		return $timestamp_remaining;
	}

	if ( $user instanceof LP_User_Guest ) {
		return $timestamp_remaining;
	}

	$course_item_data = $user->get_course_data( $course->get_id() );

	if ( ! $course_item_data ) {
		return $timestamp_remaining;
	}

	$course_start_time   = $course_item_data->get_start_time()->get_raw_date();
	$duration            = $course->get_data( 'duration' );
	$timestamp_expire    = strtotime( $course_start_time . ' +' . $duration );
	$timestamp_current   = strtotime( current_time( 'mysql' ) );
	$timestamp_remaining = $timestamp_expire - $timestamp_current;

	if ( $timestamp_remaining < 0 ) {
		$timestamp_remaining = 0;
	}

	$diff = learn_press_seconds_to_weeks( $timestamp_remaining );

	return $diff;
}


LearnPress::instance()->template( 'course' )->remove( 'learn-press/single-course-summary', array( 'single-course/content', array() ), 10 );
function single_course_content() {
	?>
	<div id="course-landing" class="course-content course-summary-content">
		<?php do_action( 'learn-press/course-content-summary' ); ?>

		<?php thim_landing_tabs(); ?>
	</div>
	<?php
}

add_action( 'learn-press/single-course-summary', 'single_course_content', 10 );

// add class fix style use don't description in page profile
add_filter( 'learn-press/profile/class', 'thim_class_has_description_user' );
function thim_class_has_description_user( $classes ) {
	$profile = LP_Profile::instance();
	$user    = $profile->get_user();
	if ( ! isset( $user ) ) {
		return;
	}
	$bio = $user->get_description();
	if ( ! $bio ) {
		$classes[] = 'no-bio-user';
	}

	return $classes;
}

/**
 * Display thumbnail course
 */

if ( ! function_exists( 'thim_courses_loop_item_thumbnail' ) ) {
	function thim_courses_loop_item_thumbnail( $course = null ) {
		$course                      = learn_press_get_course();
		$course_thumbnail_dimensions = learn_press_get_course_thumbnail_dimensions();
		$with_thumbnail              = $course_thumbnail_dimensions['width'];
		$height_thumbnail            = $course_thumbnail_dimensions['height'];
		if ( ! $course ) {
			return;
		}
		echo '<div class="course-thumbnail">';
		echo '<a class="thumb" href="' . esc_url( get_the_permalink( $course->get_id() ) ) . '" >';
		echo thim_get_feature_image( get_post_thumbnail_id( $course->get_id() ), 'full', apply_filters( 'thim_course_thumbnail_width', $with_thumbnail ), apply_filters( 'thim_course_thumbnail_height', $height_thumbnail ), $course->get_title() );
		echo '</a>';
		thim_course_wishlist_button( $course->get_id() );
		do_action( 'thim-lp-course-button-read-more' );
		echo '</div>';
	}
}
add_action( 'thim_courses_loop_item_thumb', 'thim_courses_loop_item_thumbnail' );
if ( ! function_exists( 'thim_lp_social_user' ) ) {
	function thim_lp_social_user( $user_id = '' ) {
		global $post;
		if ( ! $user_id ) {
			$user    = learn_press_get_user( $post->post_author );
			$socials = $user->get_profile_socials( $user->get_id() );
		} else {
			$user_instructor = learn_press_get_user( $user_id );
			$socials         = $user_instructor->get_profile_socials( $user_id );
		}
		?>
		<ul class="thim-author-social">
			<?php foreach ( $socials as $value ) : ?>
				<li><?php echo $value; ?></li>
			<?php endforeach; ?>
		</ul>
		<?php
	}
}

if ( ! function_exists( 'thim_print_rating' ) ) {
	function thim_print_rating( $rated ) {
		if ( version_compare( LP_ADDON_COURSE_REVIEW_VER, '4.0.6', '>=' ) ) {
			LP_Addon_Course_Review_Preload::$addon->get_template(
				'rating-stars.php',
				[ 'rated' => $rated ]
			);
		}
	}
}

function thim_redirect_to_buy_course_mobile() {
	echo '<input type="hidden" name="redirect_to" value="">';
}

add_action( 'learn-press/after-purchase-button', 'thim_redirect_to_buy_course_mobile', 5 );
add_action( 'learn-press/after-enroll-button', 'thim_redirect_to_buy_course_mobile', 5 );

// filter for package
add_filter( 'lp/upsell/archive-package/wrapper', 'lp_upsell_archive_package_wrapper_page_title' );
add_filter( 'lp/upsell/single-package/wrapper', 'lp_upsell_single_package_wrapper_page_title' );
function lp_upsell_archive_package_wrapper_page_title() {
	return array(
		thim_wapper_page_title()                                            => '',
		'<div class="learnpress-packages__wrapper site-content container">' => '</div>'
	);
}

function lp_upsell_single_package_wrapper_page_title() {
	return array(
		thim_wapper_page_title()                                            => '',
		'<div class="learnpress-packages__wrapper site-content container">' => '</div>',
		'<div class="single-package-wrapper">'                              => '</div>',
	);
}

add_filter( 'lp/upsell/archive-package/sections', function ( $section ) {
	unset( $section['header'] );

	return $section;
} );

// Overwrite support ajax course lp theme Coaching
function custom_learnpress_support_theme_no_ajax( $themes ) {

	$index = array_search( 'Coaching', $themes );
	if ( $index !== false ) {
		unset( $themes[ $index ] );
	}

	return $themes;
}

add_filter( 'lp/page/courses/themes/no_load_ajax', 'custom_learnpress_support_theme_no_ajax' );

// Support meta key language for thim-elementor-kit
add_filter( 'thim-ekit-course-key-language', function () {
	return 'thim_course_language';
} );

// instructor courses
if ( ! function_exists( 'thim_lp_instructor_courses' ) && version_compare( LEARNPRESS_VERSION, '4.2.7.6', '>=' ) ) {
	function thim_lp_instructor_courses( $sections, $courses, $instructor ) {
		if ( ! empty( $courses ) ) {
			$course_ids = array();
			foreach ( $courses as $course_obj ) {
				$course_ID    = $course_obj->ID;
				$course_ids[] = $course_ID;
			}
			$html_li_item_course = '';
			$query_course        = new WP_Query(
				array(
					'post_type'      => 'any',
					'post__in'       => $course_ids,
					'orderby'        => 'post__in',
					'posts_per_page' => - 1,
				)
			);
			while ( $query_course->have_posts() ) {
				$query_course->the_post();
				ob_start();
				learn_press_get_template_part( 'content', 'course' );
				$html_li_item_course .= ob_get_clean();
			}
			wp_reset_postdata();
			$html_courses = array(
				'wrapper'     => '<ul class="ul-instructor-courses thim-course-grid">',
				'list_course' => $html_li_item_course,
				'wrapper_end' => '</ul>',
			);

			$sections['courses'] = Template::combine_components( $html_courses );
		}

		return $sections;
	}

	add_filter( 'learn-press/single-instructor/courses/sections', 'thim_lp_instructor_courses', 10, 3 );
}
/**
 * Display course ratings
 */
if ( ! function_exists( 'thim_course_ratings' ) ) {
	function thim_course_ratings() {
		if ( ! class_exists( 'LP_Addon_Course_Review' ) || ! function_exists( 'learn_press_course_meta_primary_review' ) ) {
			return;
		}
		wp_enqueue_style( 'course-review' );
		learn_press_course_meta_primary_review();
	}
}


/**
 * Display ratings count
 */

if ( ! function_exists( 'thim_course_ratings_count' ) ) {
	function thim_course_ratings_count( $course_id = null ) {
		if ( ! thim_plugin_active( 'learnpress-course-review/learnpress-course-review.php' ) || ! thim_is_version_addons_wishlist( '3' ) ) {
			return;
		}
		if ( ! $course_id ) {
			$course_id = get_the_ID();
		}
		$ratings = learn_press_get_course_rate_total( $course_id ) ? learn_press_get_course_rate_total( $course_id ) : 0;
		echo '<div class="course-comments-count">';
		echo '<div class="value"><i class="fa fa-comment"></i>';
		echo esc_html( $ratings );
		echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'thim_course_wishlist_button' ) ) {
	function thim_course_wishlist_button( $course_id = null ) {
		if ( ! class_exists( 'LP_Addon_Wishlist' ) ) {
			return;
		}
		LP_Addon_Wishlist::instance()->wishlist_button( $course_id );
	}
}

if ( ! function_exists( 'thim_learnpress_page_title' ) ) {
	function thim_learnpress_page_title( $echo = true ) {

	}
}


/**
 * Display related courses
 */
if ( ! function_exists( 'thim_related_courses' ) ) {
	function thim_related_courses() {
		$related_courses = thim_lp_get_related_courses( 5 );
		wp_enqueue_script( 'owl-carousel' );
		if ( $related_courses->have_posts() ) {
			$layout_grid = get_theme_mod( 'thim_learnpress_cate_layout_grid', '' );
			$cls_layout  = ( $layout_grid != '' && $layout_grid != ' layout_courses_1' ) ? ' cls_courses_2' : ' ';
			?>
			<div class="thim-ralated-course<?php echo esc_attr( $cls_layout ); ?>">

				<h3 class="related-title">
					<?php esc_html_e( 'You May Like', 'coaching' ); ?>
				</h3>

				<div class="thim-course-grid">
					<div class="thim-carousel-wrapper" data-visible="3" data-itemtablet="2" data-itemmobile="1"
						 data-pagination="1">
						<?php while ( $related_courses->have_posts() ) {
							$related_courses->the_post(); ?>
							<?php
							learn_press_get_template_part( 'content', 'course' );
						} ?>
					</div>
				</div>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'thim_lp_get_related_courses' ) ) {
	function thim_lp_get_related_courses( $limit ) {
		if ( ! $limit ) {
			$limit = 3;
		}
		$course_id = get_the_ID();

		$tag_ids = array();
		$tags    = get_the_terms( $course_id, 'course_tag' );

		if ( $tags ) {
			foreach ( $tags as $individual_tag ) {
				$tag_ids[] = $individual_tag->term_id;
			}
		}

		$args = array(
			'posts_per_page'      => $limit,
			'paged'               => 1,
			'ignore_sticky_posts' => 1,
			'post__not_in'        => array( $course_id ),
			'post_type'           => 'lp_course'
		);

		if ( $tag_ids ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'course_tag',
					'field'    => 'term_id',
					'terms'    => $tag_ids
				)
			);
		}

		$query = new WP_Query( $args );

		return $query;
	}
}
if ( ! function_exists( 'thim_get_related_courses' ) ) {
	function thim_get_related_courses( $limit ) {
		if ( ! $limit ) {
			$limit = 3;
		}
		$course_id = get_the_ID();

		$tag_ids = array();
		$tags    = get_the_terms( $course_id, 'course_tag' );

		if ( $tags ) {
			foreach ( $tags as $individual_tag ) {
				$tag_ids[] = $individual_tag->slug;
			}
		}

		$args = array(
			'posts_per_page'      => $limit,
			'paged'               => 1,
			'ignore_sticky_posts' => 1,
			'post__not_in'        => array( $course_id ),
			'post_type'           => 'lp_course'
		);

		if ( $tag_ids ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'course_tag',
					'field'    => 'slug',
					'terms'    => $tag_ids
				)
			);
		}
		$related = array();
		if ( $posts = new WP_Query( $args ) ) {
			global $post;
			while ( $posts->have_posts() ) {
				$posts->the_post();
				$related[] = $post;
			}
		}
		wp_reset_query();

		return $related;
	}
}

/**
 * Display the link to course forum
 */
if ( ! function_exists( 'thim_course_forum_link' ) ) {
	function thim_course_forum_link() {

		if ( thim_plugin_active( 'bbpress/bbpress.php' ) && thim_plugin_active( 'learnpress-bbpress/learnpress-bbpress.php' ) && thim_is_version_addons_bbpress( '3' ) ) {
			LP_Addon_bbPress::instance()->forum_link();
		}
	}
}

if ( ! function_exists( 'thim_landing_tabs' ) ) {
	function thim_landing_tabs() {
		learn_press_get_template( 'single-course/tabs/tabs-landing.php' );
	}
}
if ( ! function_exists( 'thim_get_post_translated_duration' ) ) {
	function thim_get_post_translated_duration( $course_duration, $default = '' ) {
		$duration_arr = isset( $course_duration ) ? explode( ' ', $course_duration ) : '';
		$duration_str = '';
		if ( count( $duration_arr ) > 1 ) {
			$duration_number = $duration_arr[0];
			$duration_text   = $duration_arr[1];
			switch ( strtolower( $duration_text ) ) {
				case 'minute':
					$duration_str = sprintf( _n( '%s minute', '%s minutes', $duration_number, 'learnpress' ), $duration_number );
					break;
				case 'hour':
					$duration_str = sprintf( _n( '%s hour', '%s hours', $duration_number, 'learnpress' ), $duration_number );
					break;
				case 'day':
					$duration_str = sprintf( _n( '%s day', '%s days', $duration_number, 'learnpress' ), $duration_number );
					break;
				case 'week':
					$duration_str = sprintf( _n( '%s week', '%s weeks', $duration_number, 'learnpress' ), $duration_number );
					break;
				default:
					$duration_str = $course_duration;
			}
		}

		return empty( absint( $course_duration ) ) ? $default : $duration_str;
	}
}
/**
 * Display course info
 */
if ( ! function_exists( 'thim_course_info' ) ) {
	function thim_course_info() {
		$course = learn_press_get_course();
		if ( ! $course ) {
			return;
		}
		$course_id = $course->get_id();
		if ( thim_is_new_learnpress( '4.0' ) ) {
			$course_skill_level = get_post_meta( $course_id, '_lp_level', true );
			switch ( $course_skill_level ) {
				case 'beginner':
					$course_skill_level = esc_html__( 'Beginner', 'learnpress' );
					break;
				case 'intermediate':
					$course_skill_level = esc_html__( 'Intermediate', 'learnpress' );
					break;
				case 'expert':
					$course_skill_level = esc_html__( 'Expert', 'learnpress' );
					break;
				default:
					$course_skill_level = esc_html__( 'All levels', 'learnpress' );
			}
			$course_duration = get_post_meta( $course_id, 'thim_course_duration', true ) ? get_post_meta( $course_id, 'thim_course_duration', true ) : get_post_meta( $course_id, '_lp_duration', true );
		} else {
			$course_skill_level = get_post_meta( $course_id, 'thim_course_skill_level', true );
			$course_duration    = get_post_meta( $course_id, 'thim_course_duration', true );
		}

		$course_language = get_post_meta( $course_id, 'thim_course_language', true );

		?>
		<div class="thim-course-info">
			<h3 class="title"><?php esc_html_e( 'Course Features', 'coaching' ); ?></h3>
			<ul>
				<li class="lectures-feature">
					<i class="fa fa-files-o"></i>
					<span class="label"><?php esc_html_e( 'Lectures', 'coaching' ); ?></span>
					<span class="value"><?php
						// check with lp 4.1.4
						if ( thim_is_new_learnpress( '4.1.4' ) ) {
							echo $course->count_items( LP_LESSON_CPT );
						} else {
							echo count( $course->count_items( 'lp_lesson' ) );
						}
						?></span>
				</li>
				<li class="quizzes-feature">
					<i class="fa fa-puzzle-piece"></i>
					<span class="label"><?php esc_html_e( 'Quizzes', 'coaching' ); ?></span>
					<span class="value"><?php
						// check with lp 4.1.4
						if ( thim_is_new_learnpress( '4.1.4' ) ) {
							echo $course->count_items( LP_QUIZ_CPT );
						} else {
							echo count( $course->count_items( 'lp_quiz' ) );
						}
						?></span>
				</li>
				<?php if ( ! empty( $course_duration ) ): ?>
					<li class="duration-feature">
						<i class="fa fa-clock-o"></i>
						<span class="label"><?php esc_html_e( 'Duration', 'coaching' ); ?></span>
						<span
							class="value"><?php echo thim_get_post_translated_duration( $course_duration, esc_html__( 'Lifetime access', 'learnpress' ) ); ?></span>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $course_skill_level ) ): ?>
					<li class="skill-feature">
						<i class="fa fa-level-up"></i>
						<span class="label"><?php esc_html_e( 'Skill level', 'coaching' ); ?></span>
						<span class="value"><?php echo esc_html( $course_skill_level ); ?></span>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $course_language ) ): ?>
					<li class="language-feature">
						<i class="fa fa-language"></i>
						<span class="label"><?php esc_html_e( 'Language', 'coaching' ); ?></span>
						<span class="value"><?php echo esc_html( $course_language ); ?></span>
					</li>
				<?php endif; ?>
				<li class="students-feature">
					<i class="fa fa-users"></i>
					<span class="label"><?php esc_html_e( 'Students', 'coaching' ); ?></span>
					<?php $user_count = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0; ?>
					<span class="value"><?php echo esc_html( $user_count ); ?></span>
				</li>
				<?php thim_course_certificate( $course_id ); ?>
				<li class="assessments-feature">
					<i class="fa fa-check-square-o"></i>
					<span class="label"><?php esc_html_e( 'Assessments', 'coaching' ); ?></span>
					<span
						class="value"><?php echo ( get_post_meta( $course_id, '_lp_course_result', true ) == 'evaluate_lesson' ) ? esc_html__( 'Yes', 'coaching' ) : esc_html__( 'Self', 'coaching' ); ?></span>
				</li>
			</ul>
			<?php thim_course_wishlist_button(); ?>
		</div>
		<?php
	}
}

/**
 * Display feature certificate
 *
 * @param $course_id
 */
function thim_course_certificate( $course_id ) {

	if ( thim_plugin_active( 'learnpress-certificates/learnpress-certificates.php' ) && thim_is_version_addons_certificates( '3' ) ) {
		?>
		<li class="cert-feature">
			<i class="fa fa-rebel"></i>
			<span class="label"><?php esc_html_e( 'Certificate', 'coaching' ); ?></span>
			<span
				class="value"><?php echo ( get_post_meta( $course_id, '_lp_cert', true ) ) ? esc_html__( 'Yes', 'coaching' ) : esc_html__( 'No', 'coaching' ); ?></span>
		</li>
		<?php
	}
}

/**
 * Display co instructors
 *
 * @param $course_id
 */
if ( ! function_exists( 'thim_co_instructors' ) ) {
	function thim_co_instructors( $course_id, $author_id ) {
		if ( ! $course_id ) {
			return;
		}

		if ( thim_plugin_active( 'learnpress-co-instructor/learnpress-co-instructor.php' ) ) {
			$instructors = get_post_meta( $course_id, '_lp_co_teacher' );
			$instructors = array_diff( $instructors, array( $author_id ) );
			if ( $instructors ) {
				foreach ( $instructors as $instructor ) {
					//Check if instructor not exist
					$user = get_userdata( $instructor );
					if ( $user === false ) {
						break;
					}
					$lp_info = get_the_author_meta( '_lp_extra_info', $instructor );
					$link    = learn_press_user_profile_link( $instructor );
					?>
					<div class="thim-about-author thim-co-instructor" itemprop="contributor" itemscope
						 itemtype="http://schema.org/Person">
						<div class="author-wrapper">
							<div class="author-avatar">
								<?php echo get_avatar( $instructor, 110 ); ?>
							</div>
							<div class="author-bio">
								<div class="author-top">
									<a itemprop="url" class="name" href="<?php echo esc_url( $link ); ?>">
										<span
											itemprop="name"><?php echo get_the_author_meta( 'display_name', $instructor ); ?></span>
									</a>
									<?php if ( isset( $lp_info['major'] ) && $lp_info['major'] ) : ?>
										<p class="job"
										   itemprop="jobTitle"><?php echo esc_html( $lp_info['major'] ); ?></p>
									<?php endif; ?>
								</div>
								<?php if ( function_exists( 'thim_lp_social_user' ) ) {
									thim_lp_social_user( $instructor );
								} ?>

								<div class="author-description" itemprop="description">
									<?php echo get_the_author_meta( 'description', $instructor ); ?>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
		}
	}
}


/** 
 * Show thumbnail single course
 */
if ( ! function_exists( 'thim_course_thumbnail_item' ) ) {
	function thim_course_thumbnail_item() {
		learn_press_get_template( 'single-course/thumbnail.php' );
	}
}
add_action( 'learn-press/single-course-summary', 'thim_course_thumbnail_item', 2 );

/*
 * Add media for lesson
 */
if ( ! function_exists( 'thim_content_item_lesson_media' ) ) {
	function thim_content_item_lesson_media() {
		$can_view_item = '';
		$user          = learn_press_get_current_user();
		$course_item   = LP_Global::course_item();
		$course        = learn_press_get_course();
		if ( $course || $user ) {
			$can_view_item = $user->can_view_item( $course_item->get_id(), $course->get_id() );
		}

		$media_intro = get_post_meta( $course_item->get_id(), '_lp_lesson_video_intro', true );
		if ( ! empty( $media_intro ) && $can_view_item ) {
			?>
			<div class="learn-press-video-intro">
				<div class="video-content">
					<?php
					echo str_replace(
						array( "<iframe", "</iframe>" ),
						array(
							'<div class="responsive-iframe"><iframe',
							"</iframe></div>"
						),
						apply_filters( 'the_content', $media_intro )
					);
					?>
				</div>
			</div>
			<?php
		}
	}
}
add_action( 'learn-press/before-course-item-content', 'thim_content_item_lesson_media', 5 );

if ( ! function_exists( 'thim_course_tabs_content' ) ) {
	function thim_course_tabs_content( $defaults ) {

		$group_tab = get_theme_mod( 'group_tabs_course', array(
			'description',
			'curriculum',
			'instructor',
			'announcements',
			'students-list',
			'package',
			'faqs',
			'review',
			'materials',
		) );
		$group_tab = str_replace( array( 'description', 'review' ), array( 'overview', 'reviews' ), $group_tab );

		foreach ( $defaults as $k => $v ) {

			switch ( $k ) {
				case 'overview':
					$v['icon'] = 'fa-bookmark';

					break;
				case 'reviews':
					$v['icon'] = 'fa-comments';
					break;
				case 'curriculum':
					$v['icon'] = 'fa-bars';
					break;
				case 'instructor':
					$v['icon'] = 'fa-user';
					break;
				case 'announcements':
					$v['icon'] = 'fa-envelope';
					break;
				case 'students-list':
					$v['icon'] = 'fa-list';
					break;
				case 'faqs':
					$v['icon'] = 'fa-question-circle';
					break;
				case 'package':
					$v['icon'] = 'fa-cube';
					break;
				case 'materials':
					$v['icon'] = 'fa-dropbox';
					break;
			}
			$defaults[ $k ] = $v;

			$new_prioty = array_keys( $group_tab, $k );
			if ( $new_prioty ) {
				$defaults[ $k ]['priority'] = $new_prioty[0];
			} else {
				unset( $defaults[ $k ] );
			}
		}
		$tab                        = get_theme_mod( 'default_tab_course', 'description' );
		$tab                        = str_replace( array( 'description', 'review' ), array( 'overview', 'reviews' ), $tab );
		$defaults[ $tab ]['active'] = true;

		return $defaults;
	}
}

$overwritten_tab = true;
// fix tab build with thim-elementor-kit
if ( class_exists( '\Thim_EL_Kit\Functions' ) ) {
	$build_el = Functions::instance()->get_conditions_by_type( 'single-course' );
	if ( ! empty( $build_el['all'] ) ) {
		$overwritten_tab = false;
	}
}
if ( $overwritten_tab ) {
	add_filter( 'learn-press/course-tabs', 'thim_course_tabs_content', 9999 );
}
/*
 * Hide ads Learnpress
 */
if ( get_theme_mod( 'thim_learnpress_hidden_ads', false ) ) {
	remove_action( 'admin_footer', 'learn_press_footer_advertisement', - 10 );
}

/**
 * Check new version of addons LearnPress Woo Payment
 *
 * @return mixed
 */
function thim_is_version_addons_woo_payment( $version ) {
	if ( defined( 'LP_ADDON_WOO_PAYMENT_VER' ) ) {
		return ( version_compare( LP_ADDON_WOO_PAYMENT_VER, $version, '>=' ) );
	}

	return false;
}

/*
 * add button read more action thim-lp-course-button-read-more
 * Fix for add-on LP Woo Payment has button add-to-cart
 */
if ( ! function_exists( 'thim_button_read_more_course' ) ) {
	function thim_button_read_more_course() {
		$course = learn_press_get_course();
		if ( $course ) {
			echo '<a class="course-readmore" href="' . esc_url( get_the_permalink( $course->get_id() ) ) . '">' . esc_html__( 'Read More', 'coaching' ) . '</a>';
		}
	}
}
