<?php
/**
 * Thim_Builder Button config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Countdown_Box' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Countdown_Box extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Countdown_Box constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'countdown-box';
			self::$name =  esc_html__( 'Thim: Countdown Box', 'coaching' );
			self::$desc = esc_html__( 'Display Countdown Box.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-countdown-box';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Days', 'coaching' ),
					'param_name'  => 'text_days',
					'std'         => esc_html__( 'days', 'coaching' ),
					'group'       => esc_html__( 'Text Settings', 'coaching' ),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Hours', 'coaching' ),
					'param_name'  => 'text_hours',
					'std'         => esc_html__( 'hours', 'coaching' ),
					'group'       => esc_html__( 'Text Settings', 'coaching' ),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Minutes', 'coaching' ),
					'param_name'  => 'text_minutes',
					'std'         => esc_html__( 'minutes', 'coaching' ),
					'group'       => esc_html__( 'Text Settings', 'coaching' ),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Seconds', 'coaching' ),
					'param_name'  => 'text_seconds',
					'std'         => esc_html__( 'seconds', 'coaching' ),
					'group'       => esc_html__( 'Text Settings', 'coaching' ),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Year', 'coaching' ),
					'param_name'  => 'time_year',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Month', 'coaching' ),
					'param_name'  => 'time_month',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Day', 'coaching' ),
					'param_name'  => 'time_day',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Hour', 'coaching' ),
					'param_name'  => 'time_hour',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Style Color', 'coaching' ),
					'param_name'  => 'style_color',
					'value'       => array(
						esc_html__( 'White', 'coaching' ) => 'white',
						esc_html__( 'Black', 'coaching' ) => 'black',
					),
					'group'       => esc_html__( 'Text Settings', 'coaching' ),
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text alignment', 'coaching' ),
					'param_name'  => 'text_align',
					'value'       => array(
						esc_html__( 'Text at left', 'coaching' )   => 'text-left',
						esc_html__( 'Text at center', 'coaching' ) => 'text-center',
						esc_html__( 'Text at right', 'coaching' )  => 'text-right',
					),
					'group'       => esc_html__( 'Text Settings', 'coaching' ),
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
