<?php
/**
 * Thim_Builder Counters Box config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Counters_Box' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Counters_Box extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Counters_Box constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'counters-box';
			self::$name = esc_html__( 'Thim: Counters Box', 'coaching');
			self::$desc = esc_html__('Display Counters Box.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-counters-box';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Counters Label', 'coaching' ),
					'param_name'  => 'counters_label',
					'std'         => '',
				),

				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Counters Value', 'coaching' ),
					'param_name'  => 'counters_value',
					'std'         => '20',
				),

				array(
					'type'        => 'iconpicker',
					'admin_label' => true,
					'heading'     => esc_html__( 'Select Icon', 'coaching' ),
					'param_name'  => 'icon',
					'group'       => esc_html__( 'Icon Settings', 'coaching' ),
				),


				array(
					'type'        => 'colorpicker',
					'admin_label' => true,
					'heading'     => esc_html__( 'Border Color Icon', 'coaching' ),
					'param_name'  => 'border_color',
					'group'       => esc_html__( 'Icon Settings', 'coaching' ),
				),

				array(
					'type'        => 'colorpicker',
					'admin_label' => true,
					'heading'     => esc_html__( 'Counters Icon Color', 'coaching' ),
					'param_name'  => 'counter_color',
					'group'       => esc_html__( 'Icon Settings', 'coaching' ),
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Style', 'coaching' ),
					'param_name'  => 'style',
					'value'       => array(
						esc_html__( 'Home Page', 'coaching' )      => 'home-page',
						esc_html__( 'Page About Us', 'coaching' )  => 'about-us',
						esc_html__( 'Home Effective', 'coaching' ) => 'home-effective',
						esc_html__( 'Home 5 Style', 'coaching' )   => 'home-5',
					),
				),

				//Animation
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Animation', 'coaching' ),
					'param_name'  => 'css_animation',
					'admin_label' => true,
					'value'       => array(
						esc_html__( 'No', 'coaching' )                 => '',
						esc_html__( 'Top to bottom', 'coaching' )      => 'top-to-bottom',
						esc_html__( 'Bottom to top', 'coaching' )      => 'bottom-to-top',
						esc_html__( 'Left to right', 'coaching' )      => 'left-to-right',
						esc_html__( 'Right to left', 'coaching' )      => 'right-to-left',
						esc_html__( 'Appear from center', 'coaching' ) => 'appear'
					),
					'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'coaching' )
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
