<?php
/**
 * Thim_Builder Visual Composer Course Categories shortcode
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_VC_Course_Categories' ) ) {
	/**
	 * Class Thim_Builder_VC_Carousel_Categories
	 */
	class Thim_Builder_VC_Course_Categories extends Thim_Builder_VC_Shortcode {

		/**
		 * Thim_Builder_VC_Course_Categories constructor.
		 */
		public function __construct() {
			// set config class
			$this->config_class = 'Thim_Builder_Config_Course_Categories';

			parent::__construct();
		}

		// convert setting course_categories
		function thim_convert_setting( $settings ) {
			$settings['slider-options']['limit']           = $settings['slider_limit'];
			$settings['slider-options']['show_pagination'] = $settings['slider_show_pagination'];
			$settings['slider-options']['show_navigation'] = $settings['slider_show_navigation'];
			$settings['slider-options']['item_visible']    = $settings['slider_item_visible'];
			$settings['list-options']['show_counts']       = $settings['list_show_counts'];
			$settings['list-options']['hierarchical']      = $settings['list_hierarchical'];

			return $settings;
		}
	}
}

new Thim_Builder_VC_Course_Categories();
