<?php
/**
 * Thim_Builder Carousel Categories config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Course-Categories' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Course_Categories extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Carousel_Categories constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'course-categories';
			self::$name = esc_html__( 'Thim: Course Categories', 'coaching' );
			self::$desc = esc_html__( 'Show course categories', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-course-categories';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Layout', 'coaching' ),
					'param_name'  => 'layout',
					'value'       => array(
						esc_html__( 'List Categories', 'coaching' ) => 'list',
						esc_html__( 'Slider', 'coaching' )          => 'slider'
					),
				),

				array(
					'type'          => 'number',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Limit categories', 'coaching' ),
					'param_name'    => 'slider_limit',
					'param_name_so' => 'limit',
					'std'           => '15',
					'group'         => esc_html__( 'Slider Settings', 'coaching' ),
					'group_id'      => 'slider-options',
					'dependency'    => array(
						'element' => 'layout',
						'value'   => 'slider',
					),
				),

				array(
					'type'          => 'checkbox',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Show Pagination', 'coaching' ),
					'param_name'    => 'slider_show_pagination',
					'param_name_so' => 'show_pagination',
					'std'           => false,
					'dependency'    => array(
						'element' => 'layout',
						'value'   => 'slider',
					),
					'group'         => esc_html__( 'Slider Settings', 'coaching' ),
					'group_id'      => 'slider-options',
				),

				array(
					'type'          => 'checkbox',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Show Navigation', 'coaching' ),
					'param_name'    => 'slider_show_navigation',
					'param_name_so' => 'show_navigation',
					'std'           => true,
					'dependency'    => array(
						'element' => 'layout',
						'value'   => 'slider',
					),
					'group'         => esc_html__( 'Slider Settings', 'coaching' ),
					'group_id'      => 'slider-options',
				),

				array(
					'type'          => 'dropdown',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Items visible', 'coaching' ),
					'param_name'    => 'slider_item_visible',
					'param_name_so' => 'item_visible',
					'value'         => array(
						esc_html__( 'Select', 'coaching' ) => '',
						esc_html__( '1', 'coaching' )      => '1',
						esc_html__( '2', 'coaching' )      => '2',
						esc_html__( '3', 'coaching' )      => '3',
						esc_html__( '4', 'coaching' )      => '4',
						esc_html__( '5', 'coaching' )      => '5',
						esc_html__( '6', 'coaching' )      => '6',
						esc_html__( '7', 'coaching' )      => '7',
						esc_html__( '8', 'coaching' )      => '8',
					),
					'dependency'    => array(
						'element' => 'layout',
						'value'   => 'slider',
					),
					'group'         => esc_html__( 'Slider Settings', 'coaching' ),
					'group_id'      => 'slider-options',
				),

				array(
					'type'          => 'checkbox',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Show course count', 'coaching' ),
					'param_name'    => 'list_show_counts',
					'param_name_so' => 'show_counts',
 					'std'           => false,
					'dependency'    => array(
						'element' => 'layout',
						'value'   => 'list',
					),
					'group'         => esc_html__( 'List Options', 'coaching' ),
					'group_id'      => 'list-options',
				),

				array(
					'type'          => 'checkbox',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Show hierarchy', 'coaching' ),
					'param_name'    => 'list_hierarchical',
					'param_name_so' => 'hierarchical',
					'std'           => false,
					'dependency'    => array(
						'element' => 'layout',
						'value'   => 'list',
					),
					'group'         => esc_html__( 'List Options', 'coaching' ),
					'group_id'      => 'list-options',
				),

			);
		}
	}
}
