<?php
/**
 * Thim_Builder Visual Composer Google Map shortcode
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_VC_Google_Map' ) ) {
	/**
	 * Class Thim_Builder_VC_Google_Map
	 */
	class Thim_Builder_VC_Google_Map extends Thim_Builder_VC_Shortcode {

		/**
		 * Thim_Builder_VC_Google_Map constructor.
		 */
		public function __construct() {
			// set config class
			$this->config_class = 'Thim_Builder_Config_Google_Map';

			parent::__construct();
		}

		// convert setting
		function thim_convert_setting( $settings ) {
 			//			$settings['markers']['marker_positions'] = (array) vc_param_group_parse_atts( $settings['marker_positions'] );
			$settings['settings']['height']          = $settings['settings_height'];
			$settings['location']['lat']             = $settings['location_lat'];
			$settings['location']['lng']             = $settings['location_lng'];
			$settings['address']                     = $settings['map_center'];
			$settings['settings']['zoom']            = $settings['settings_zoom'];
			$settings['settings']['scroll_zoom']     = $settings['settings_scroll_zoom'];
			$settings['settings']['draggable']       = $settings['settings_draggable'];
			$settings['markers']['marker_at_center'] = $settings['marker_at_center'];
			$settings['markers']['marker_icon']      = $settings['marker_icon'];
			$settings['markers']['marker_positions'] = isset( $settings['marker_positions'] ) ? $settings['marker_positions'] : '';

			return $settings;
		}
	}
}

new Thim_Builder_VC_Google_Map();
