<?php
/**
 * Thim_Builder List Event config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_List_Event' ) ) {
	/**
	 * Class Thim_Builder_Config_List_Event
	 */
	class Thim_Builder_Config_List_Event extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_List_Event constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'list-event';
			self::$name = esc_html__( 'Thim: List Events', 'coaching' );
			self::$desc = esc_html__( 'Display List Events.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-list-event';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Layout', 'coaching' ),
					'param_name'  => 'layout',
					'value'       => array(
						esc_html__( 'Default', 'coaching' )  => 'base',
						esc_html__( 'Layout Business', 'coaching' )   => 'layout-business',
						esc_html__( 'Layout 2', 'coaching' ) => 'layout-2',
						esc_html__( 'Layout Effective', 'coaching' ) => 'layout-effective',
					),
				),

				array(
					'type'       => 'dropdown_multiple',
					'heading'    => esc_html__( 'Select Category', 'coaching' ),
					'param_name' => 'cat_id',
					'value'      => thim_get_cat_taxonomy( 'tp_event_category', array( esc_html__( 'All', 'coaching' ) => 'all' ), true ),
				),

				array(
					'type'       => 'dropdown_multiple',
					'heading'     => esc_html__( 'Select Status', 'coaching' ),
					'param_name'  => 'status',
					'std'        => '',
					'value'       => array(
						esc_html__( 'Upcoming', 'coaching' )  => 'upcoming',
						esc_html__( 'Happening', 'coaching' )   => 'happening',
						esc_html__( 'Expired', 'coaching' ) => 'expired',
					),
				),

				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Number events display', 'coaching' ),
					'param_name'  => 'number_posts',
					'std'         => '2',
				),

				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Feature Items', 'coaching' ),
					'param_name'  => 'feature_items',
					'std'         => '2',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text View All', 'coaching' ),
					'param_name'  => 'text_link',
					'std'         => esc_html__( 'View All', 'coaching' ),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Url Link All', 'coaching' ),
					'param_name'  => 'url_link',
					'std'         => '#',
				),
			);
		}

	}
}
