<?php
/**
 * Thim_Builder Login Form config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Login_Form' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Login_Form extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Login_Form constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'login-form';
			self::$name = esc_html__( 'Thim: Login Form', 'coaching' );
			self::$desc = esc_html__( 'Display Login Form.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-login-form';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Captcha', 'coaching' ),
					'param_name'  => 'captcha',
					'value'       => array(
						esc_html__( 'No', 'coaching' )   => 'no',
						esc_html__( 'Yes', 'coaching' )  => 'yes',
					),
					'description' => esc_html__( 'Use captcha in register form', 'coaching' ),
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
