<?php
/**
 * Thim_Builder Login Form config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Login_Menu' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Login_Menu extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Login_Menu constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'login-menu';
			self::$name = esc_html__( 'Thim: Login Menu', 'coaching' );
			self::$desc = esc_html__( 'Add Login Menu', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-login-form';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Login', 'coaching' ),
					'value'       => esc_html__('Login', 'coaching'),
					'param_name'  => 'text_login',
				),
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Register', 'coaching' ),
					'value'       => esc_html__('Register', 'coaching'),
					'param_name'  => 'text_register',
				),
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Logout', 'coaching' ),
					'value'       => esc_html__('Logout', 'coaching'),
					'param_name'  => 'text_logout',
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
