<?php
/**
 * Thim_Builder Login Form config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Login_Popup' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Login_Popup extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Login_Popup constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'login-popup';
			self::$name = esc_html__( 'Thim: Login Popup', 'coaching' );
			self::$desc = esc_html__( 'Add Login popup', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-login-form';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'dropdown',
					'admin_label' => false,
					'heading'     => esc_html__( 'Show Register Link', 'coaching' ),
					'param_name'  => 'show_register',
					'value'       => array(
						esc_html__( 'No', 'coaching' )  => 'no',
						esc_html__( 'Yes', 'coaching' ) => 'yes',
					),
					'description' => esc_html__( 'Use captcha in register form', 'coaching' ),
				),
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Login', 'coaching' ),
					'value'       => esc_html__( 'Login', 'coaching' ),
					'param_name'  => 'text_login',
				),
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Register', 'coaching' ),
					'value'       => esc_html__( 'Register', 'coaching' ),
					'param_name'  => 'text_register',
				),
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Logout', 'coaching' ),
					'value'       => esc_html__( 'Logout', 'coaching' ),
					'param_name'  => 'text_logout',
				),
				array(
					'type'        => 'dropdown',
					'admin_label' => false,
					'heading'     => esc_html__( 'Style', 'coaching' ),
					'param_name'  => 'style',
					'value'       => array(
						esc_html__( 'Normal', 'coaching' )          => '',
						esc_html__( 'Effective Style', 'coaching' ) => 'layout_2',
						esc_html__( 'Therapist Style', 'coaching' ) => 'layout_3',
						esc_html__( 'Home 5 Style', 'coaching' )    => 'layout_4',
					),
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Shortcode', 'coaching' ),
					'description' => esc_html__( 'Enter shortcode to show in form Login', 'coaching' ),
					'value'       => '',
					'param_name'  => 'shortcode',
				),
			);
		}

	}
}
