<?php
/**
 * Thim_Builder Our Team config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Our_Team' ) ) {
	/**
	 * Class Thim_Builder_Config_Our_Team
	 */
	class Thim_Builder_Config_Our_Team extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Our_Team constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'our-team';
			self::$name = esc_html__( 'Thim: Our Team', 'coaching' );
			self::$desc = esc_html__( 'Display Our Team.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-our-team';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {
			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Select Category', 'coaching' ),
					'param_name'  => 'cat_id',
					'value'       =>  thim_get_cat_taxonomy( 'our_team_category', array( esc_html__( 'All', 'coaching' ) => 'all' ), true  ),
				),

				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Number Posts', 'coaching' ),
					'param_name'  => 'number_post',
					'std'         => '5',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Layout', 'coaching' ),
					'param_name'  => 'layout',
					'value'       => array(
						esc_html__( 'Default', 'coaching' ) => 'base',
						esc_html__( 'Layout Busines', 'coaching' )  => 'layout-business',
					),
					'std'         => 'base',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Columns', 'coaching' ),
					'param_name'  => 'columns',
					'value'       => array(
						esc_html__( 'Select', 'coaching' ) => '',
						esc_html__( '1 Column', 'coaching' ) => '1',
						esc_html__( '2 Columns', 'coaching' ) => '2',
						esc_html__( '3 Columns', 'coaching' ) => '3',
						esc_html__( '4 Columns', 'coaching' ) => '4',
					),
					'std'         => '1',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Link', 'coaching' ),
					'param_name'  => 'text_link',
					'value'       => '',
					'description' => esc_html__( 'Provide the text link that will be applied to box our team.', 'coaching' ),
					'std'         => '',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Link Join Team', 'coaching' ),
					'param_name'  => 'link',
					'value'       => '',
					'description' => esc_html__( 'Provide the link that will be applied to box our team', 'coaching' ),
					'std'         => '',
				),

				array(
					'type'        => 'checkbox',
					'admin_label' => true,
					'heading'     => esc_html__( 'Enable Link To Member', 'coaching' ),
					'param_name'  => 'link_member',
 					'std'         => false,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Animation', 'coaching' ),
					'param_name'  => 'css_animation',
					'admin_label' => true,
					'value'       => array(
						esc_html__( 'No', 'coaching' )                 => '',
						esc_html__( 'Top to bottom', 'coaching' )      => 'top-to-bottom',
						esc_html__( 'Bottom to top', 'coaching' )      => 'bottom-to-top',
						esc_html__( 'Left to right', 'coaching' )      => 'left-to-right',
						esc_html__( 'Right to left', 'coaching' )      => 'right-to-left',
						esc_html__( 'Appear from center', 'coaching' ) => 'appear'
					),
					'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'coaching' )
				),
			);
		}
	}
}
