<?php
/**
 * Created by lucky boy.
 * User: dong-it
 */
global $post;

wp_enqueue_script( 'thim-isotope' );
wp_enqueue_script( 'magnific-popup' );
wp_enqueue_script( 'thim-portfolio-appear' );
wp_enqueue_script( 'thim-portfolio-widget' );
$class           = '';
$category        = empty( $instance['portfolio_category'] ) ? array() : $instance['portfolio_category']; 
$filter_hiden    = $instance['filter_hiden'] ? $instance['filter_hiden'] : false;
$filter_position = isset( $instance['filter_position'] ) ? $instance['filter_position'] : 'center';
$description     = $instance['show_description'];
$paging          = isset( $instance['paging'] ) ? $instance['paging'] : '';
$item_size       = isset( $instance['item_size'] ) ? $instance['item_size'] : '';
$gutter          = isset( $instance['gutter'] ) ? $instance['gutter'] : '';
$num_per_view    = isset( $instance['num_per_view'] ) ? $instance['num_per_view'] : "";
if ( $category == 'all' ) {
	$category = array();
}
if ( isset( $category[''] ) && is_array( $category[''] ) ) {
	$category = $category[''];

}
$css_filter_position = ' style="text-align:' . $filter_position . ';"';
// Gutter
if ( $gutter == true ) {
	$class_gutter = " gutter";
} else {
	$class_gutter = "";
}
// Column
$class_column = isset( $instance['column'] ) ? $instance['column'] . '-col' : 'two-col';

// Paging
if ( $paging == 'paging' ) {
	if ( is_front_page() ) {
		$paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
	} else {
		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	}
	if ( $num_per_view != '' ) { // overide number
		$argss = array(
			'post_type'      => 'portfolio',
			'posts_per_page' => $num_per_view,
			'paged'          => $paged
		);
	} else {// using number in config
		$argss = array(
			'post_type' => 'portfolio',
			'paged'     => $paged
		);
	}

} else {
	if ( $paging == 'limit' ) {
		if ( $num_per_view != '' ) { // overide number
			$argss = array(
				'post_type'      => 'portfolio',
				'posts_per_page' => $num_per_view
			);
		} else {// using number in config
			$argss = array(
				'post_type' => 'portfolio'
			);
		}

	} else {
		if ( $paging == 'infinite_scroll' ) {
			if ( is_front_page() ) {
				$paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
			} else {
				$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
			}
			if ( $num_per_view != '' ) { // overide number
				$argss = array(
					'post_type'      => 'portfolio',
					'posts_per_page' => $num_per_view,
					'paged'          => $paged
				);
			} else {// using number in config
				$argss = array(
					'post_type' => 'portfolio',
					'paged'     => $paged
				);
			}
		} else { // show all post
			$argss = array(
				'post_type'      => 'portfolio',
				'posts_per_page' => - 1
			);
		}
	}
}

if ( ( is_array( $category ) && ! empty( $category ) ) || ( ! is_array( $category ) && $category ) ) {
	$argss['tax_query'][] = array(
		'taxonomy' => 'portfolio_category',
		'field'    => 'ID',
		'terms'    => $category
	);
}

$gallery = new WP_Query( $argss );
global $portfolio_data;


$number_total = max( $gallery->post_count, $paging );
if ( is_array( $gallery->posts ) && ! empty( $gallery->posts ) && $gallery->post_count ) {
	foreach ( $gallery->posts as $gallery_post ) {
		$post_taxs = wp_get_post_terms( $gallery_post->ID, 'portfolio_category', array( "fields" => "all" ) );
		if ( is_array( $post_taxs ) && ! empty( $post_taxs ) ) {
			foreach ( $post_taxs as $post_tax ) {
				if ( is_array( $category ) && ! empty( $category ) && ( in_array( $post_tax->term_id, $category ) || in_array( $post_tax->parent, $category ) ) ) {
					$portfolio_taxs[ urldecode( $post_tax->slug ) ] = $post_tax->name;
				}
				if ( empty( $category ) || ! isset( $category ) ) {
					$portfolio_taxs[ urldecode( $post_tax->slug ) ] = $post_tax->name;
				}
			}
		}
	}
} else {
	return;
}
$style_items = $instance['style-item'];
?>
<div
	class="wapper_portfolio <?php echo esc_attr( $class_gutter ); ?> <?php echo esc_attr( $item_size ); ?> <?php echo esc_attr( $paging ); ?> <?php echo esc_attr( $style_items ); ?>"
	data-loadmore="<?php echo esc_attr( $num_per_view ); ?>">
	<?php if ( $filter_hiden !== true ) { ?>
		<div class="portfolio-tabs-wapper filters"<?php echo ent2ncr( $css_filter_position ); ?> >
			<ul class="portfolio-tabs">
				<?php if ( empty( $category ) ) { ?>
					<li>
						<a href="#" class="filter active"
						   data-filter="*"><?php echo esc_html__( 'All', 'coaching' ); ?></a>
					</li>
					<?php foreach ( $portfolio_taxs as $portfolio_tax_slug => $portfolio_tax_name ): ?>
						<li>
							<a class="filter" href="#"
							   data-filter=".<?php echo ent2ncr( $portfolio_tax_slug ); ?>"><?php echo ent2ncr( $portfolio_tax_name ); ?></a>
						</li>
					<?php endforeach;
				} else {
					$term = get_term( $category, 'portfolio_category' );
					$name = $term->name;
					$slug = $term->slug;
					?>
					<li>
						<a class="filter active" href
						   data-filter=".<?php echo esc_attr( $slug ); ?>"><?php echo esc_html( $name ); ?></a>
					</li>
					<?php
				}
				?>
			</ul>
		</div>
	<?php } ?>
	<div class="portfolio_column">
		<ul class="content_portfolio <?php echo esc_attr( $style_items ); ?>">
			<?php
			while ( $gallery->have_posts() ): $gallery->the_post();

				$image_crop = '';
				$post_id    = get_the_ID();
				$permalink  = get_permalink( $post_id );
				// Get post meta once.
				$feature_images = get_post_meta( $post_id, 'feature_images', true );
				$bk_ef          = get_post_meta( $post_id, 'thim_portfolio_bg_color_ef', true );
				$bg             = $bk_ef ? sprintf( 'style="background-color:%s;"', esc_attr( $bk_ef ) ) : '';

				// Size mapping for cleaner code.
				$size_map = array(
					'size11' => array( 'image' => 'portfolio_size11', 'class' => '' ),
					'size12' => array( 'image' => 'portfolio_size12', 'class' => ' height_large' ),
					'size21' => array( 'image' => 'portfolio_size21', 'class' => ' item_large' ),
					'size22' => array( 'image' => 'portfolio_size22', 'class' => ' height_large item_large' ),
				);

				$logo = get_post_meta( $post_id, 'thim_portfolio_project_logo', false );
				if ( isset( $logo ) && ! empty( $logo ) ) {
					$logo_attachment = wp_get_attachment_image_src( $logo[0], 'full' );
					if ( $logo_attachment ) {
						$thim_logo_src = $logo_attachment[0];
						$logo_size     = ' width="' . $logo_attachment[1] . '" height="' . $logo_attachment[2] . '"';
					}
					$html_title = '<img class="project-logo" src="' . $thim_logo_src . '" alt="' . esc_attr( get_the_title( get_the_ID() ) ) . '" ' . $logo_size . ' />';
				} else {
					$html_title = get_the_title( get_the_ID() );
				}

				$images_size  = 'portfolio_size11';
				$item_classes = $class_size = '';

				if ( 'multigrid' === $item_size ) {
					if ( isset( $size_map[ $feature_images ] ) ) {
						$images_size = $size_map[ $feature_images ]['image'];
						$class_size  = $size_map[ $feature_images ]['class'];
					} else {
						// Random size if not specified.
						$random_key  = array_rand( $size_map );
						$images_size = $size_map[ $random_key ]['image'];
						$class_size  = $size_map[ $random_key ]['class'];
					}
					$class_size .= ' ' . $class_column;
				} elseif ( 'masonry' === $item_size ) {
					$images_size = 'full';
					$class_size  = $class_column;
				} else {
					$class_size = $class_column;
				}

				// Build category classes.
				$cat_links = array();
				$item_cats = get_the_terms( $post_id, 'portfolio_category' );
				if ( $item_cats && ! is_wp_error( $item_cats ) ) {
					foreach ( $item_cats as $item_cat ) {
						$item_classes .= urldecode( $item_cat->slug ) . ' ';
						$cat_links[]  = sprintf(
							'<a href="%s">%s</a>',
							esc_url( get_term_link( $item_cat ) ),
							esc_html( $item_cat->name )
						);
					}
				}

				// Get image.
				$image_id   = get_post_thumbnail_id( $post_id );
				$post_title = get_the_title( $post_id );
				$imgurl     = false;

				if ( 'masonry' === $item_size ) {
					$width  = 600;
					$imgurl = wp_get_attachment_image_src( $image_id, 'full' );
					if ( $imgurl && isset( $imgurl[1], $imgurl[2] ) && $imgurl[1] > 0 ) {
						$ratio  = $imgurl[2] / $imgurl[1];
						$height = (int) round( $width * $ratio );
						$imgurl = wp_get_attachment_image_src( $image_id, array( $width, $height ) );
					}
					$image_url = sprintf(
						'<img src="%s" alt="%s"   />',
						$imgurl ? esc_url( $imgurl[0] ) : '',
						esc_attr( $post_title ),
					);
				} else {
					$imgurl = wp_get_attachment_image_src( $image_id, array( 480, 320 ) );
					if ( 'multigrid' === $item_size && $imgurl ) {
						$image_url = sprintf(
							'<div class="thumb-img" style="background-image: url(%s);"><img src="%s" alt="%s" /></div>',
							esc_url( $imgurl[0] ),
							esc_url( $imgurl[0] ),
							esc_attr( $post_title )
						);
					} else {
						$image_url = sprintf(
							'<img src="%s" alt="%s" />',
							$imgurl ? esc_url( $imgurl[0] ) : '',
							esc_attr( $post_title )
						);
					}
				}


				echo '<li data-color="' . $bk_ef . '" class="element-item ' . $item_classes . ' item_portfolio ' . $class_size . '" ' . $bg . '>';
				echo '<div class="portfolio-image">';
				echo '<div class="img-portfolio">' . $image_url . '</div>';
				echo '<div class="portfolio-hover" ' . $bg . '><div class="thumb-bg"><div class="mask-content">';
				echo '<h3><a href="' . esc_url( $permalink ) . '" title="' . esc_attr( $post_title ) . '" >' . $html_title . '</a></h3>';

				if ( ! empty( $cat_links ) ) : ?>
					<div class="cat_portfolio">
						<?php echo wp_kses_post( implode( ', ', $cat_links ) ); ?>
					</div>
				<?php endif;

				if ( $description != '' ) :
					echo thim_excerpt( 15 );
				endif;

				echo '<a href="' . esc_url( $permalink ) . '" title="' . esc_attr( $post_title ) . '" class="btn_zoom">' . esc_html__( 'View More', 'coaching' ) . '</a>';

				echo '</div></div></div></div>';
				echo '</li>';
			endwhile;
			wp_reset_postdata();
			?>
		</ul>
		<?php
		$show_readmore = $instance['show_readmore'];
		$btn_text      = esc_html__( 'View More', 'coaching' );
		if ( $show_readmore == true ) {
			echo '<div class="read-more">';
			echo '<a class="thim-button" href="' . esc_url( home_url( '/' ) ) . 'portfolio/">' . $btn_text . '</a>';
			echo '</div>';
		}
		if ( in_array( $paging, array( 'paging', 'infinite_scroll' ) ) ) {
			echo '<div class="pagination loop-pagination tp-loop-pagination">';
			$total_pages = $gallery->max_num_pages;
			for ( $i = 1; $i <= $total_pages; $i++ ) {
				$page_class = ( $i == $paged ) ? 'active' : '';
				echo '<a href="' . esc_url( add_query_arg( 'paged', $i ) ) . '" class="' . esc_attr( $page_class ) . '">' . intval( $i ) . '</a>';
			}
			echo '</div>';
		}

		if ( $paging == 'load_more' ) {
			echo '<div class="load-container" style="text-align: center"><button id="load-more">' . esc_html__( 'Load More', 'coaching' ) . '</button></div>';
		} ?>
	</div>
</div>
