<?php
/**
 * Thim_Builder Program config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Program' ) ) {
	/**
	 * Class Thim_Builder_Config_Program
	 */
	class Thim_Builder_Config_Program extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Program constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'program';
			self::$name = esc_html__( 'Thim: Program', 'coaching' );
			self::$desc = esc_html__( 'Add Program', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-icon-box';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'dropdown',
					'admin_label' => false,
					'heading'     => esc_html__( 'Text alignment', 'coaching' ),
					'param_name'  => 'text_align',
					'value'       => array(
						esc_html__( 'Text at center', 'coaching' ) => 'text-center',
						esc_html__( 'Text at left', 'coaching' )   => 'text-left',
						esc_html__( 'Text at right', 'coaching' )  => 'text-right',
					),
					'std'         => 'text-center',
				),
				array(
					'type'        => 'dropdown',
					'admin_label' => false,
					'heading'     => esc_html__( 'Style', 'coaching' ),
					'param_name'  => 'style',
					'value'       => array(
						esc_html__( 'Normal', 'coaching' ) => 'normal',
						esc_html__( 'Slider', 'coaching' ) => 'slider',
					),
					'std'         => 'normal',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => __( 'Select Columns', 'tutorx' ),
					'param_name' => 'columns',
					'value'      => array(
						esc_html__( '2 columns', 'tutorx' ) => '2',
						esc_html__( '3 columns', 'tutorx' ) => '3',
						esc_html__( '4 columns', 'tutorx' ) => '4',
						esc_html__( '6 columns', 'tutorx' ) => '6',
					),
					'std'        => '3',
					'dependency' => array(
						'element' => 'style',
						'value'   => 'normal',
					),
				),
				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Items', 'coaching' ),
					'param_name'  => 'program',
					'params'      => array(
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							'heading'     => esc_html__( 'Title Of Program', 'coaching' ),
							'param_name'  => 'program_title',
						),
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							'heading'     => esc_html__( 'Link Of Program', 'coaching' ),
							'param_name'  => 'program_link',
						),
						array(
							'type'        => 'attach_image',
							'admin_label' => false,
							'heading'     => esc_html__( 'Image Of Program', 'coaching' ),
							'param_name'  => 'program_image',
							'description' => esc_html__( 'Select image from media library.', 'coaching' ),
						),
					)
				),
			);
		}

//		public function get_template_name() {
//			return 'base';
//		}
	}
}
