<?php
/**
 * Thim_Builder Progress Step config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Round_Slider' ) ) {
	/**
	 * Class Thim_Builder_Config_Round_Slider
	 */
	class Thim_Builder_Config_Round_Slider extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Round_Slider constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'round-slider';
			self::$name = esc_html__( 'Thim: Progress Step', 'coaching' );
			self::$desc = esc_html__( 'Add round slider box', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-icon-box';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {
			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this Round Slider.', 'coaching' ),
				),
				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Items', 'coaching' ),
					'param_name'  => 'panel',
					'params'      => array(
						array(
							'type'        => 'dropdown',
							'admin_label' => false,
							'heading'     => esc_html__( 'Type of Box', 'coaching' ),
							'param_name'  => 'panel_type',
							'value'       => array(
								__( 'Image', 'coaching' )     => 'image',
								__( 'Video', 'coaching' )   => 'video',
							),
						),
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							'heading'     => esc_html__( 'Title', 'coaching' ),
							'param_name'  => 'panel_title',
							'description' => esc_html__( 'Title of the panel', 'coaching' ),
						),
						array(
							'type'        => 'attach_image',
							'admin_label' => false,
							'heading'     => esc_html__( 'Image Thumbnail', 'coaching' ),
							'param_name'  => 'panel_image',
							'description' => esc_html__( 'Select image from media library.', 'coaching' ),
						),
						array(
							'type'        => 'attach_image',
							'admin_label' => false,
							'heading'     => esc_html__( 'Image Large', 'coaching' ),
							'param_name'  => 'panel_image_large',
							'description' => esc_html__( 'Select image from media library.', 'coaching' ),
							'dependency'  => array(
								'element' => 'panel_type',
								'value'   => 'image',
							),
						),
						array(
							'type'        => 'textarea',
							'admin_label' => false,
							'heading'     => esc_html__( 'Video URL or Embeded Code', 'coaching' ),
							'param_name'  => 'panel_video',
							'std'         => esc_html__( 'Just display with type Video', 'coaching' ),
							'dependency'  => array(
								'element' => 'panel_type',
								'value'   => 'video',
							),
						),
					)
				),
			);
		}
		public function get_template_name() {
			return 'base';
		}
	}
}
