<?php
/**
 * Thim_Builder Services config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Services' ) ) {
	/**
	 * Class Thim_Builder_Config_Services
	 */
	class Thim_Builder_Config_Services extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Services constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'services';
			self::$name = esc_html__( 'Thim: Services', 'coaching' );
			self::$desc = esc_html__( 'Add service box', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-icon-box';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Service', 'coaching' ),
					'param_name'  => 'service',
					'params'      => array(
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							'heading'     => esc_html__( 'Title', 'coaching' ),
							'param_name'  => 'service_title',
						),
						array(
							'type'        => 'attach_image',
							'admin_label' => false,
							'heading'     => esc_html__( 'Image Of Box', 'coaching' ),
							'description' => esc_html__( 'Select image from media library.', 'coaching' ),
							'param_name'  => 'service_image',
						),
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							"label"       => esc_html__( "Add Link", 'coaching' ),
							"description" => esc_html__( "Provide the link that will be applied to this icon box.", 'coaching' ),
							'param_name'  => 'service_link',
						),
						array(
							'type'        => 'colorpicker',
							'admin_label' => false,
							'heading'     => esc_html__( 'Color', 'coaching' ),
							'param_name'  => 'service_bg_color',
							'value'       => '#ff9b9a',
							'description' => esc_html__( 'Select the color.', 'coaching' ),
						),
					),
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
