<?php
wp_enqueue_script( 'thim-slick' );
$class_layout = $open_link = $close_link = '' ;
$service_list = isset( $instance['service'] ) ? $instance['service'] : '';
$column = 4;

if ( isset( $instance['layout'] ) ) {
	$class_layout = $instance['layout'];
}
if ( isset( $instance['layout'] ) && $instance['layout'] != 'base' && isset( $instance['columns'] ) ) {
	$column = $instance['columns'];
}
?>
<div class="thim-service <?php echo esc_attr( $class_layout ); ?>">
	<?php if ( isset( $instance['layout'] ) && $instance['layout'] == 'grid') : ?>
		<?php foreach ( $service_list as $key => $service ) {
			$service_url = isset( $service['service_link'] ) ? $service['service_link'] : '#';
			?>
			<div class="event-item">
				<?php
				echo '<a href="' . $service_url . '">';
					if ( is_array( $service['service_image'] ) ) {
						echo thim_get_feature_image( $service['service_image']['id'] );
					} else {
						echo thim_get_feature_image( $service['service_image'] );
					}
				echo '</a>';
				echo '<div class="thim-service-content">';
				if ( !empty( $service['service_title'] ) ) {
					echo '<h4 class="thim-service-content__title"><a href="' . $service_url . '">' . $service['service_title'] . '</a></h4>';
				}
				if ( !empty( $service['service_desc'] ) ) {
					echo '<div class="thim-service-content__description">' . $service['service_desc'] . '</div>';
				}
				if ( !empty( $service['service_link_text'] ) ) {
					echo '<a class="thim-service-content__readmore" href="' . $service_url . '">' . $service['service_link_text'] . '';
					if ( isset( $instance['icon'] ) && ! empty( $instance['icon']['value'] ) ) {
						echo '<i class="' . $instance['icon']['value'] . '"></i> ';
					}
					echo '</a>';
				}
				echo '</div>';
				?>
			</div>
		<?php } ?>
	<?php else : ?>
		<div class="slide-events js-call-slick-col" data-numofslide="<?php echo esc_attr( $column ); ?>" data-numofscroll="1" data-loopslide="1"
			data-autoscroll="0" data-speedauto="6000"
			data-respon="[4, 1], [3, 1], [3, 1], [2, 1], [1, 1]">
			<div class="wrap-arrow-slick">
				<div class="arow-slick prev-slick">
					<?php if ( isset( $instance['layout'] ) && $instance['layout'] == 'slide-2') : ?>
						<i aria-hidden="true" class="fas fa-arrow-right"></i>
					<?php else : ?>
						<i class="ion ion-ios-arrow-thin-right"></i>
					<?php endif; ?>
				</div>

				<div class="arow-slick next-slick">
					<?php if ( isset( $instance['layout'] ) && $instance['layout'] == 'slide-2') : ?>
						<i aria-hidden="true" class="fas fa-arrow-left"></i>
					<?php else : ?>
						<i class="ion ion-ios-arrow-thin-left"></i>
					<?php endif; ?>
					
				</div>
			</div>

			<div class="wrap-arrow-slick-clone">
				<div class="arow-slick next-slick"></div>
			</div>

			<div class="slide-slick">
				<?php foreach ( $service_list as $key => $service ) {
					$service_url = isset( $service['service_link'] ) ? $service['service_link'] : '#';
					?>
					<div class="item-slick">
						<div class="event-item">
							<?php
							echo '<a href="' . $service_url . '">';
								if ( is_array( $service['service_image'] ) ) {
									echo thim_get_feature_image( $service['service_image']['id'] );
								} else {
									echo thim_get_feature_image( $service['service_image'] );
								}
							echo '</a>';

							if ( isset( $instance['layout'] ) && $instance['layout'] != 'base' ) {
								echo '<div class="thim-service-content">';
								if ( !empty( $service['service_title'] ) ) {
									echo '<h4 class="thim-service-content__title"><a href="' . $service_url . '">' . $service['service_title'] . '</a></h4>';
								}
								if ( !empty( $service['service_desc'] ) ) {
									echo '<div class="thim-service-content__description">' . $service['service_desc'] . '</div>';
								}
								if ( !empty( $service['service_link_text'] ) ) {
									echo '<a class="thim-service-content__readmore" href="' . $service_url . '">' . $service['service_link_text'] . '';
									if ( isset( $instance['icon'] ) && ! empty( $instance['icon']['value'] ) ) {
										echo '<i class="' . $instance['icon']['value'] . '"></i> ';
									}
									echo '</a>';
								}
								echo '</div>';
							} else {
								if ( ! empty( $service['service_bg_color'] ) ) { ?>
									<a href="<?php echo esc_url( $service_url ) ?>" class="link-color"
									style="background-color: <?php echo $service['service_bg_color'] ?>"></a>
								<?php } 
								if ( $service['service_title'] ) {
									echo '<div class="thim-service-title"><a href="' . $service_url . '">' . $service['service_title'] . '</a></div>';
								}
							}
							?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	<?php endif; ?>
</div>
