<?php
/**
 * Thim_Builder Single Images config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Single_Images' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Single_Images extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Single_Images constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'single-images';
			self::$name = esc_html__( 'Thim: Single Image', 'coaching' );
			self::$desc = esc_html__( 'Display single images.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-single-images';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {
			// options
			return array(
				array(
					'type'        => 'attach_image',
					'admin_label' => true,
					'heading'     => esc_html__( 'Image', 'coaching' ),
					'param_name'  => 'image',
					'description' => esc_html__( 'Select image from media library.', 'coaching' )
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Image size', 'coaching' ),
					'param_name'  => 'image_size',
					'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'coaching' ),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Image Link', 'coaching' ),
					'param_name'  => 'image_link',
					'description' => esc_html__( 'Enter URL if you want this image to have a link.', 'coaching' ),
				),

				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Link Target', 'coaching' ),
					'param_name' => 'link_target',
					'value'      => array(
						esc_html__( 'Same window', 'coaching' ) => '_self',
						esc_html__( 'New window', 'coaching' )  => '_blank',
					)
				),

				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Image alignment', 'coaching' ),
					'param_name'  => 'image_alignment',
					'description' => esc_html__( 'Select image alignment.', 'coaching' ),
					'value'       => array(
						esc_html__( 'Align Left', 'coaching' )   => 'left',
						esc_html__( 'Align Center', 'coaching' ) => 'center',
						esc_html__( 'Align Right', 'coaching' )  => 'right',
					)
				),

				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Animation', 'coaching' ),
					'param_name'  => 'css_animation',
					'admin_label' => true,
					'value'       => array(
						esc_html__( 'No', 'coaching' )                 => '',
						esc_html__( 'Top to bottom', 'coaching' )      => 'top-to-bottom',
						esc_html__( 'Bottom to top', 'coaching' )      => 'bottom-to-top',
						esc_html__( 'Left to right', 'coaching' )      => 'left-to-right',
						esc_html__( 'Right to left', 'coaching' )      => 'right-to-left',
						esc_html__( 'Appear from center', 'coaching' ) => 'appear'
					),
					'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'coaching' )
				),

			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
