<?php
/**
 * Thim_Builder Social Counter config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Social_Counter' ) ) {
	/**
	 * Class Thim_Builder_Config_Social_Counter
	 */
	class Thim_Builder_Config_Social_Counter extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Social_Counter constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'social-counter';
			self::$name = esc_html__( 'Thim: Social Count Plus', 'coaching' );
			self::$desc = esc_html__( 'Add Social Count', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-our-team';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {
			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
			);
		}
		public function get_template_name() {
			return 'base';
		}
	}
}
