<?php
/**
 * Thim_Builder Social config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Social' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Social extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Social constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'social';
			self::$name = esc_html__( 'Thim: Social', 'coaching' );
			self::$desc = esc_html__( 'Display social icon.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-social';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Style', 'coaching' ),
					'param_name'  => 'style',
					'value'       => array(
						esc_html__( 'Default', 'coaching' ) => '',
						esc_html__( 'No Border', 'coaching' ) => 'no-border',
					),
				),

				array(
					'type'        => 'checkbox',
					'admin_label' => true,
					'heading'     => esc_html__( 'Show text social', 'coaching' ),
					'param_name'  => 'show_text',
					'std'         => false,
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Facebook Url', 'coaching' ),
					'param_name'  => 'link_face',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Twitter Url', 'coaching' ),
					'param_name'  => 'link_twitter',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Google Url', 'coaching' ),
					'param_name'  => 'link_google',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Dribble Url', 'coaching' ),
					'param_name'  => 'link_dribble',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Linkedin Url', 'coaching' ),
					'param_name'  => 'link_linkedin',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Pinterest Url', 'coaching' ),
					'param_name'  => 'link_pinterest',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Instagram Url', 'coaching' ),
					'param_name'  => 'link_instagram',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Youtube Url', 'coaching' ),
					'param_name'  => 'link_youtube',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Snapchat Url', 'coaching' ),
					'param_name'  => 'link_snapchat',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Link Target', 'coaching' ),
					'param_name'  => 'link_target',
					'value'       => array(
						esc_html__( 'Select', 'coaching' )      => '',
						esc_html__( 'Same window', 'coaching' ) => '_self',
						esc_html__( 'New window', 'coaching' )  => '_blank',
					),
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
